#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "TextLCD.h"
#include "Websocket.h"
#include "Counter.h"
#include "SDFileSystem.h"
#include "uplink.h"

TextLCD lcd(p20, p19, p18, p17, p16, p15,TextLCD::LCD20x4); // rs, e, d4-d7
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board

NTPClient ntp;
int offset_DK = 7200;
Counter T1(p22);
AnalogIn tempsensor(p16);


float ReadTempetur(void)
{
    float tempreading=(tempsensor.read()*3.3-0.25)/0.028;
    return  tempreading;
}

float TankContens()
{
//beregner hvor meget der er tilbage
    return 1000-T1.Flow();
}

void InitLog(void) {
    FILE *fp; //Logfile
    fp = fopen("/sd/taptraq/Tank.log", "r");
    if (fp == NULL)  //For at være sikker på at der er en fil og skrive i
      fp = fopen("/sd/taptraq/Tank.log", "w");
    fclose(fp);
}

void LogToSd(void)
{
    FILE *fp; //Logfile
    time_t seconds = time(NULL);
    char timestr[32];
    seconds = time(NULL);
    strftime(timestr, 32, "%Y/%m/%d-%H:%M:%S", localtime(&seconds));
    fp = fopen("/sd/taptraq/Tank.log", "a");
    fprintf(fp,"%s,%.4f,%.1f\r\n",
            timestr,T1.Flow(),ReadTempetur());
    fclose(fp);
}

int main()
{
    time_t seconds = time(NULL);
    char timestr[32];
    lcd.printf("Establishing...\n");
    lcd.printf("Network Connection\n");
    EthernetInterface eth;
    eth.init(); //Use DHCP
    if (eth.connect()<0) NVIC_SystemReset();
    lcd.cls();
    lcd.printf("Located IP ADR....\n");
    lcd.printf("IP: - %s\n", eth.getIPAddress());
    printf("IP: %s\n", eth.getIPAddress());
    Websocket ws("ws://sockets.mbed.org/ws/gert_lauritsen/rw");
    wait(3);
    lcd.cls();
    lcd.printf("Reconnecting...\n");
    lcd.printf("TapTraQ Uplink\n");
    while (!ws.connect());
    lcd.cls();
    lcd.printf("Faild Connect...\n");
    lcd.printf("TapTraQ Uplink\n");
    wait(5);
    TapTraqUplink Uplink(&ws);
    /* Set up NTP */
   // printf("Setting up NTP \n\r");
    //ntp.setTime("0.dk.pool.ntp.org",123);
    //ntp.setTime("ntp1.jst.mfeed.ad.jp",123);
    lcd.cls();
    strftime(timestr, 32, "%H:%M", localtime(&seconds));
    lcd.printf("%s \n",timestr);
    wait(1);
    InitLog();
    while (1) { //Vis temperatur og mængde i tank
        lcd.cls();
        seconds = time(NULL)+offset_DK;
        strftime(timestr, 32, "%H:%M", localtime(&seconds));
        lcd.printf("TapTraQ Count System");
        lcd.printf("KOLKKEN - %s\n",timestr);
        lcd.printf("TEMP %.2f C\n",ReadTempetur());
        lcd.printf("TANK %.1f - %.1f L \n",TankContens(),T1.Flow());
        Uplink.FlowFrame("1000",1,T1.Count,0,0,0,0,0,0);
        LogToSd();
        wait(10);
    }
}
