
#ifndef _TapTraqUplink_H
#define _TapTraqUplink_H

#include "Websocket.h"
#include "mbed.h"
#include <string>

#define MAX_NUMBER 10
#define SetupStrSize 100
#define MaxCtrl 10 //max antal ctrl der hænger på en gateway


class TapTraqUplink
{
public:
    typedef struct {//Der er en setuprec for hver hane
        uint16_t ID,           //Hane ID
                 TabType,      //Hane type om det er sodavand eller øl hanne
                 EscTryk,      //mulighed for at hvis man tryker en ekstra gang, vil den stoppe med det samme
                 FlowEnable,   //Hvis der er flowmåler
                 FlowMode,     //0: stop ved flow, 1 fritløb sender ved timeout 2: festival mode sender hvert 10 s
                 IntervalUpload, //sekunder mellem hver upload
                 //SmartTab
                 XLOn, XLPause, XLTopup,
                 LOn, LPause, LTopup,
                 MOn, MPause, MTopup,
                 SOn, SPause, STopup;
    } SetupRec; //længde = 43byte

    typedef struct {//Der er en
        char EUID[17];//uniq 64 identify
        char ID;      //id internt
    } PanIdRec;

//er hvor meget der er kommet igennem hver enkelt hane
    /**
    *   Constructor
    *
    * @param id Name of the client on the network
    * @param ws All communication between clients will be established over this websocket
    */


    TapTraqUplink(Websocket *webs) : webs(webs), index(0), index_proc(0) {
        std::string path = webs->getPath();
        std::string token = "/";
        size_t found;
        found = path.find(token);
        if (found != std::string::npos)
            found = path.find(token, found + 1);
        if (found != std::string::npos)
            path = path.substr(found + 1, std::string::npos);
        for (char ID=0; ID<MAX_NUMBER; ID++) {
            strcpy(PanId[ID].EUID,"0000000000000000");
            PanId[ID].ID=0;
        }
//       strcpy(my_id, path.c_str());
    };
//socket del
    //sender en flowfram fra en counter til database
    void FlowFrame (char *ID,uint8_t TapID, uint32_t Flow, uint32_t Spild, uint16_t Temp, uint16_t Key1,uint16_t Key2,uint16_t Key3,uint16_t Key4);
    //Sender et givet setup record til database
    void setuprec (char ID, char *node);
    //Frame til tank måler
    void TankFlowFrame (char *ID, float latitude, float longitude, uint32_t Flow, float Temp);    
    //Sender gateways ID    
    void alive(char *p);

    //sender ID for en counter tilkoblet gateway
    void panlist(char *gateway, char id);

    //chekcer for indgående beskeder fra WS
    int work();
    char RxStr;
    //Modtager setuprecord om gemmer dem på SDkort
    void Rxsetuprec();
    //dekode setup record modtaget fra ctrl. Denne sendes i to dele derfor denne opdeling
    void RxSetuprec1(char *p,char CtrlNr);
    void RxSetuprec2(char *p,char CtrlNr);

//Logger/gemme del
    //læser alle setup record ind i hukommelse
    void ReadConfig();
    //skriver en default setup for alle
    void WriteDefault(void);
    //gemmer setuprecords fra hukommelse til SD kort
    void SaveConfig();
    //åbner på, hvis ikke den kan finde en opsætning skriver den en default
    void iniopen(void);

    void SavePanID();
    void ReadPanID();

    SetupRec SetupArr[MAX_NUMBER*MaxCtrl];
    PanIdRec PanId[MaxCtrl]; //10 stik 64 bit Paid
    int CheckPan(char *p);
    bool AddPan(char *p);

    char json_recv[100]; //modtaget data
private:
    Websocket * webs;
    int index;
    int index_proc;
    char my_id[20];

    char Confrec[MAX_NUMBER][SetupStrSize];
};




#endif
