#include "uplink.h"
//---------------------------------------------------------------------------------------------------------------------------------------------------------------
//Frames til T2
void TapTraqUplink::FlowFrame (char *ID,uint8_t TapID, uint32_t Flow, uint32_t Spild, uint16_t Temp, uint16_t Key1,uint16_t Key2,uint16_t Key3,uint16_t Key4)
{
    time_t sec = time(NULL);
    char tidstr[32];
    sec = time(NULL);
    strftime(tidstr, 32, "%Y/%m/%d-%H:%M:%S", localtime(&sec));
    sprintf(json_recv, "{1,%s,%s,%x,%x,%x,%x,%x,%x,%x,%x}" ,ID,tidstr,TapID,Flow,Spild,Temp,Key1,Key2,Key3,Key4);
    webs->send(json_recv);
}

void TapTraqUplink::setuprec (char ID, char *node)
{
    sprintf(json_recv, "{2,%s,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x}",node,
            SetupArr[ID].ID, SetupArr[ID].TabType, SetupArr[ID].EscTryk, SetupArr[ID].FlowEnable,
            SetupArr[ID].FlowMode, SetupArr[ID].IntervalUpload,
            SetupArr[ID].XLOn, SetupArr[ID].XLPause, SetupArr[ID].XLTopup,
            SetupArr[ID].LOn,  SetupArr[ID].LPause,  SetupArr[ID].LTopup,
            SetupArr[ID].MOn,  SetupArr[ID].MPause,  SetupArr[ID].MTopup,
            SetupArr[ID].SOn,  SetupArr[ID].SPause,  SetupArr[ID].STopup);
    webs->send(json_recv);
}

void TapTraqUplink::TankFlowFrame (char *ID, float latitude, float longitude, uint32_t Flow, float Temp)
{
    time_t sec = time(NULL);
    char tidstr[32];
    sec = time(NULL);
    strftime(tidstr, 32, "%Y/%m/%d-%H:%M:%S", localtime(&sec));
    sprintf(json_recv,"{%s,%s,%.4f,%.4f,%d,%.1f}",
              ID,tidstr,latitude,longitude,Flow,Temp);   
    webs->send(json_recv);
}


void TapTraqUplink::alive(char *p)
{
    sprintf(json_recv, "{100,%s}",p); //sender gateway ID
    webs->send(json_recv);
}

void TapTraqUplink::panlist(char *gateway, char id)
{
    sprintf(json_recv, "{101,%s,%d,%s}",gateway,id,PanId[id].EUID); //sender gateway ID
    webs->send(json_recv);
}


//---------------------------------------------------------------------------------------------------------------------------------------------------------------
//Frames fra T2
//dekodning af beskeder
//Setup frames
void TapTraqUplink::Rxsetuprec()
{
    SetupRec Setup; //vi er nødt til at ligge det over i et setup inde vi ved hvilke setup der kommet
    sscanf(json_recv,"{2,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x}",
           &Setup.ID, &Setup.TabType,&Setup.EscTryk,&Setup.FlowEnable,
           &Setup.FlowMode, &Setup.IntervalUpload,
           &Setup.XLOn, &Setup.XLPause, &Setup.XLTopup,
           &Setup.LOn,  &Setup.LPause,  &Setup.LTopup,
           &Setup.MOn,  &Setup.MPause,  &Setup.MTopup,
           &Setup.SOn,  &Setup.SPause,  &Setup.STopup);
    memcpy(&SetupArr[Setup.ID].ID,&Setup.ID,sizeof(Setup)); //kopiere den over
    SaveConfig(); //Skriv den til disk
}
//setup frames fra ZB, der skal dekodes og gemmes her
void TapTraqUplink::RxSetuprec1(char *p,char CtrlNr)
{
    SetupRec SetupData; //vi er nødt til at ligge det over i et setup inde vi ved hvilke setup der kommet
    sscanf(p,"02,%X,%X,%X,%X,%X,%X",
           &SetupData.ID, &SetupData.TabType, &SetupData.EscTryk, &SetupData.FlowEnable,
           &SetupData.FlowMode, &SetupData.IntervalUpload);
    memcpy(&SetupArr[SetupData.ID+(CtrlNr*MaxCtrl)].ID,&SetupData.ID,sizeof(SetupData)); //kopiere den over
}

void TapTraqUplink::RxSetuprec2(char *p,char CtrlNr )
{
    char id;
    SetupRec SetupData; //vi er nødt til at ligge det over i et setup inde vi ved hvilke setup der kommet
    sscanf(p,"03,%X,%X,%X,%X,%X,%X,%X,%X,%X,%X,%X,%X,%X", &SetupData.ID,
           &SetupData.XLOn, &SetupData.XLPause, &SetupData.XLTopup,
           &SetupData.LOn, &SetupData.LPause, &SetupData.LTopup,
           &SetupData.MOn, &SetupData.MPause, &SetupData.MTopup,
           &SetupData.SOn, &SetupData.SPause, &SetupData.STopup);
    //SetupData.ID er setup rec numeret for den enkelte ctrl (0..9)
    //Derudover skal vi vide hvilke ctrl det er (1..MaxCtrl)       
    id=SetupData.ID+(CtrlNr*MaxCtrl);
    SetupArr[id].XLOn=SetupData.XLOn;
    SetupArr[id].XLPause=SetupData.XLPause;
    SetupArr[id].XLTopup=SetupData.XLTopup;
    SetupArr[id].LOn=SetupData.LOn;
    SetupArr[id].LPause=SetupData.LPause;
    SetupArr[id].LTopup=SetupData.LTopup;
    SetupArr[id].MOn=SetupData.MOn;
    SetupArr[id].MPause=SetupData.MPause;
    SetupArr[id].MTopup=SetupData.MTopup;
    SetupArr[id].SOn=SetupData.SOn;
    SetupArr[id].SPause=SetupData.SPause;
    SetupArr[id].STopup=SetupData.STopup;    
    SaveConfig(); //Skriv den til disk
}
//Det var nok om setup records, tilbage til T2

//T vil gerne se hvordan setup er for en given counter

//T vil gerne se en liste over hvilke counter der er online



//---------------------------------------------------------------------------------------------------------------------------------------------------------------
int TapTraqUplink::work()
{
    if (webs->read(json_recv)) return 1;
    else return 0;
}
//--------------------------Pan liste-------------------------------------------------------
//gem liste over PANID, som vi kan se
void TapTraqUplink::SavePanID()
{
    char str[200];
    FILE *fp = fopen("/sd/taptraq/PanId.sys", "w"); //
    sprintf(str, "{%s,%s,%s,%s,%s,%s,%s,%s,%s,%s}\r\n",
            PanId[0].EUID,PanId[1].EUID,PanId[2].EUID,PanId[3].EUID,PanId[4].EUID,PanId[5].EUID,PanId[6].EUID,PanId[7].EUID,PanId[8].EUID,PanId[9].EUID);
    fputs(str, fp);
    sprintf(str, "{%x,%x,%x,%x,%x,%x,%x,%x,%x,%x}\r\n",
            PanId[0].ID,PanId[1].ID,PanId[2].ID,PanId[3].ID,PanId[4].ID,PanId[5].ID,PanId[6].ID,PanId[7].ID,PanId[8].ID,PanId[9].ID);
    fputs(str, fp);
    fclose(fp);
}

void TapTraqUplink::ReadPanID()
{
    char str[200];
    char *p_items;
    FILE *fp = fopen("/sd/taptraq/PanId.sys", "r"); //
    p_items = fgets(str, SetupStrSize, fp); //
    strtok(str, "\n\0");  // change \n to \0 method
    strtok(str, "\r\0");  // change \n to \0 method
    sscanf(str, "{%s,%s,%s,%s,%s,%s,%s,%s,%s,%s}",
           PanId[0].EUID,PanId[1].EUID,PanId[2].EUID,PanId[3].EUID,PanId[4].EUID,PanId[5].EUID,PanId[6].EUID,PanId[7].EUID,PanId[8].EUID,PanId[9].EUID);
    p_items = fgets(str, SetupStrSize, fp); //
    strtok(str, "\n\0");  // change \n to \0 method
    strtok(str, "\r\0");  // change \n to \0 method
    sscanf(str, "{%x,%x,%x,%x,%x,%x,%x,%x,%x,%x}",
           PanId[0].ID,PanId[1].ID,PanId[2].ID,PanId[3].ID,PanId[4].ID,PanId[5].ID,PanId[6].ID,PanId[7].ID,PanId[8].ID,PanId[9].ID);
    fclose(fp);
}

bool TapTraqUplink::AddPan(char *p)
{
    char i=0;
    while ((PanId[i].ID!=0) & (i<MaxCtrl)) i++;
    if (i<MaxCtrl) {
        strncpy(PanId[i].EUID,p,16);
        PanId[i].ID=i+1;
        SavePanID(); //Skriver den til SD-kortet
        return true;
    } else {
        return false;
    }
}

int TapTraqUplink::CheckPan(char *p)
//finder hvad ctrl nummeret er ud fra pan id.
//ctrl nummeret er mellem 0..MaxCtrl
{
    char i=0;
    int fundet=-1;
    char TmpEUID[17];
    strcpy(TmpEUID,p);
    while ((PanId[i].ID!=0) & (i<MaxCtrl)) {
        if (strcmp(PanId[i].EUID, TmpEUID) == 0) fundet=i;
        i++;
    }
    return fundet;
}

//------------------Ini file----------------------------------------------------------------
//Vi gemmer setup records på SDkort i Ascii format, således at vi senere kan rette i dem
//Read læser dem alle ind i hukommelsen
//Save skriver dem tilbage på SD kortet

void TapTraqUplink::ReadConfig()
{
    //læser det hele igennem for at finde setup record for den pågældende ctrl
    char str[SetupStrSize];
    char *p_items;
    char dummy;
    FILE *fp = fopen("/sd/taptraq/config.sys", "r");
    if (fp != NULL) {
        for (int ID=0; ID<MAX_NUMBER*MaxCtrl; ID++) {
            p_items = fgets(str, SetupStrSize, fp); //
            strtok(str, "\n\0");  // change \n to \0 method
            strtok(str, "\r\0");  // change \n to \0 method
            if (p_items == NULL)  break;
            sscanf(str,"{%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x}",dummy,  //dummy fordi vi ved det er den ctrl
                   &SetupArr[ID].ID, &SetupArr[ID].TabType, &SetupArr[ID].EscTryk, &SetupArr[ID].FlowEnable,
                   &SetupArr[ID].FlowMode, &SetupArr[ID].IntervalUpload,
                   &SetupArr[ID].XLOn, &SetupArr[ID].XLPause, &SetupArr[ID].XLTopup,
                   &SetupArr[ID].LOn,  &SetupArr[ID].LPause,  &SetupArr[ID].LTopup,
                   &SetupArr[ID].MOn,  &SetupArr[ID].MPause,  &SetupArr[ID].MTopup,
                   &SetupArr[ID].SOn,  &SetupArr[ID].SPause,  &SetupArr[ID].STopup);
        }
    }
}

void TapTraqUplink::WriteDefault(void)
{
    for (char i=0; i<MAX_NUMBER*MaxCtrl; i++) {
        SetupArr[i].ID=i%MaxCtrl;
        SetupArr[i].TabType=0;
        SetupArr[i].EscTryk=1;
        SetupArr[i].FlowEnable=0;
        SetupArr[i].FlowMode=0;
        SetupArr[i].IntervalUpload=600;
        SetupArr[i].XLOn=0;
        SetupArr[i].XLPause=0;
        SetupArr[i].XLTopup=0;
        SetupArr[i].LOn=0;
        SetupArr[i].LPause=0;
        SetupArr[i].LTopup=0;
        SetupArr[i].MOn=0;
        SetupArr[i].MPause=0;
        SetupArr[i].MTopup=0;
        SetupArr[i].SOn=0;
        SetupArr[i].SPause=0;
        SetupArr[i].STopup=0;
    }
    SaveConfig();
}


void TapTraqUplink::SaveConfig()   //writes config to sdcard
{
    char str[SetupStrSize];
    FILE *fp = fopen("/sd/taptraq/config.sys", "w"); //
    for (int ID=0; ID<MAX_NUMBER*MaxCtrl; ID++) {
        sprintf(str, "{%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x}\r\n", ID+1,
                SetupArr[ID].ID, SetupArr[ID].TabType, SetupArr[ID].EscTryk, SetupArr[ID].FlowEnable,
                SetupArr[ID].FlowMode, SetupArr[ID].IntervalUpload,
                SetupArr[ID].XLOn, SetupArr[ID].XLPause, SetupArr[ID].XLTopup,
                SetupArr[ID].LOn,  SetupArr[ID].LPause,  SetupArr[ID].LTopup,
                SetupArr[ID].MOn,  SetupArr[ID].MPause,  SetupArr[ID].MTopup,
                SetupArr[ID].SOn,  SetupArr[ID].SPause,  SetupArr[ID].STopup);

        fputs(str, fp);
//        printf(str);
    }
    fclose(fp);
}

void TapTraqUplink::iniopen(void)
{
    FILE *fp = fopen("/sd/taptraq/config.sys", "r");
    if (fp == NULL) { //For at være sikker på at der er nogle data
        fclose(fp);
        printf("Failure to read a configuration file.\n");
        WriteDefault();
    } else fclose(fp);
    ReadConfig();
}
