#include "mbed.h"
#include "TextLCD.h"
#include "DHT.h"

#define VoltDevider 16.0*3.3 // --- Voltade devider Solar Cell --1k--|---15k--- 50V "V"
#define VoltBatDevider 9.2*3.3 // --- Voltade devider Battery --1k--|---8.2k--- 30V "V"
#define ISensorFaktor 1*3.5 // --- ACS712T 5A "I"

RawSerial pc(USBTX, USBRX);//Serial LOG

AnalogIn Ain1(p20);// --- Voltade devider Battery --1k--|---8.2k--- 30V "V"
AnalogIn Ain2(p19);// --- ACS712T 5A "I"
AnalogIn CellLow1(p18);// --- Voltade devider Solar Cell --1k--|---15k--- 50V "V"
AnalogIn CellLow2(p17);// --- Voltade devider Solar Cell --1k--|---15k--- 50V "V"
AnalogIn CellTotal(p16);// --- Voltade devider Solar Cell --1k--|---15k--- 50V "V"

AnalogIn tempsensor1(p15);//AD22103 Sensor
DHT dht22(p13,DHT22);  //Udendørs temperatur

TextLCD lcd(p26, p25, p24, p23, p22, p21, TextLCD::LCD20x4); // rs, e, d4-d7

InterruptIn Knap(p14);
DigitalOut LCDBackLigth(p12);
Timeout BL;

void LCDDisplay(int menu);

float VRaw; //This will store our raw ADC data
float IRaw;

float UdeTemp;
float UdeHym;
float Cells[4];

int menustate=1;

float ReadTempetur(void)
{
    float tempreading=(tempsensor1.read()*3.3-0.25)/0.028;
    return  tempreading;
}


void LEDOff()
{
    LCDBackLigth=0;
    LCDDisplay(0);
}

void LEDON()
{
    LCDBackLigth=1;
    BL.attach(&LEDOff,10.0);
    LCDDisplay(menustate);
    menustate++;
    if (menustate>3) menustate=1;
}


void LCDDisplay(int menu)
{
    switch (menu) {
        case 0: {
            lcd.cls();
            lcd.printf("###################\n");
            lcd.printf("#### TuxiNet.dk ###\n");
            lcd.printf("### Solar Charger #\n");
            lcd.printf("###################");
        }
        break;

        case 1: {
            lcd.cls();
            lcd.printf("Battery\n");
            lcd.printf("%.2fV  %.2fA %.2fW\n",VRaw,IRaw,IRaw*VRaw);
        }
        break;

        case 2: {
            lcd.cls();
            lcd.printf("Temp:\n");
            lcd.printf("Inde %.2fC\n Ude: %.2fC %.1f%\n",ReadTempetur(),UdeTemp,UdeHym);
        }
        break;

        case 3: {
            lcd.cls();
            lcd.printf("Solar Cell:\n");
            lcd.printf("C1 %.1f C2 %.1f\n C3 %.1f C4 %.1f\n",Cells[0],Cells[1],Cells[2],Cells[3]);
        }
        break;

        case 4: {
            lcd.cls();
            lcd.printf("Reng / LUX");
            lcd.printf("");
        }
        break;
    }
}

int main()
{
    Knap.rise(&LEDON);
    LCDDisplay(0);
    while(1) {
        VRaw = Ain1.read()*VoltBatDevider;
        IRaw = ((Ain2.read()*3.3)-2.5)*ISensorFaktor;
        Cells[0]=CellLow1.read()*VoltDevider;
        Cells[1]=CellLow2.read()*VoltDevider;
        Cells[2]=CellTotal.read()*VoltDevider-Cells[0];
        Cells[3]=CellTotal.read()*VoltDevider-Cells[1];

        int err=dht22.readData();
        wait(2.0);
        if (err==0) {
            UdeTemp=dht22.ReadTemperature(CELCIUS);
            UdeHym=dht22.ReadHumidity();
        }

        //Serial Log
        pc.printf("Bettery:\r\n");
        pc.printf("%.3f Volts  %.3f Amps %.3f watt\r\n",VRaw,IRaw,IRaw*VRaw);
        pc.printf("Temp:\r\n");
        pc.printf("Inde %.2fC Ude: %.2fC %.1f% \n\r",ReadTempetur(),UdeTemp,UdeHym);
        pc.printf("Solar Cell:\r\n");
        pc.printf("C1 %.1f C2 %.1f C3 %.1f C4 %.1f \n\n\r",Cells[0],Cells[1],Cells[2],Cells[3]);



        wait(2.0);
    }
}
