#include "mbed.h"
#include "TextLCD.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
I2C i2c(p9,p10);
TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD20x2);        // 4bit bus: rs, e, d4-d7

int main() {
    char last_command=0;
    char previous_command=0;
    char current_char=0;
    char address=0;
    char data [255];
    char current_byte=0;
    char cmd[255];
    int cmd_count=0;
    int data_count=0;
    int read=0;
    int write=0;
    int first_data_byte=0;
    int i=0;

    myled=1;
    i2c.frequency(75000);
    i2c.start();
    i2c.stop();
    // Send a start message to RealTerm
    lcd.printf("\fmbed I2C debug tool ready\n\r");
    // Scan for I2C devices that reply with ack
    for (i=0; i<=254; i=i+2) {
        if (i2c.read(i, &data[0], 1) ==0) printf("I2C device detected at address=%2.2X\n\r", i);
    }
    data[0]=0;
    i2c.start();
    i2c.stop();
// Loop processing command strings from RealTerm
    while (1) {
        current_char = pc.getc();
        // Is it a two character ASCII string data byte value
        if ((current_char <='F') && (current_char !='?')) {
            // convert to a binary byte
            if (current_char <='9') current_byte = current_char - '0';
            else current_byte =current_char +10 -'A';
            current_char = pc.getc();
            if (current_char >'F') lcd.printf("error|\n\r");
            if (current_char <='9') current_byte = (current_byte <<4) | (current_char - '0');
            else current_byte = (current_byte <<4)|(current_char +10 -'A');
            // first byte after S command is the I2C address
            if (first_data_byte==1) {
                first_data_byte=0;
                address=current_byte;
                lcd.printf(" -I2C address=%2.2X ", address);
                //Odd I2C address is a read and even is a write
                if ((address & 0x01) == 0) write=1;
                else read=1;
            } else
                // Read in cmd bytes for write
                if ((last_command == 'S')&&(read==0)) {
                    cmd[cmd_count]=current_byte;
                    cmd_count++;
                }
            // number of bytes for a read
            if ((last_command =='R')||(read==1)) data_count=current_byte;
        } else {
            // Not a number - it is a command character
            last_command = current_char;
            switch (last_command) {
                    // Start
                case 'S':
                    if (previous_command == 'S') i2c.start();
                    first_data_byte=1;
                    break;
                    // Stop
                case 'P':
                    // Do the I2C write
                    if (write==1) {
                        lcd.printf(" write ");
                        if (i2c.write(address,cmd,cmd_count)!=0) lcd.printf(" No Ack! ");
                        for (i=0; i<cmd_count; i++)
                            lcd.printf(" cmd=%2.2X ", cmd[i]);
                    }
                    // Do the I2C read
                    if (read==1) {
                        lcd.printf(" read ");
                        if (i2c.read(address, data, data_count) != 0) lcd.printf(" No Ack! ");
                        for (i=0; i<data_count; i++)
                            lcd.printf(" data=%2.2X ",data[i]);
                    }
                    // reset values for next I2C operation
                    i2c.stop();
                    lcd.printf("\n\r");
                    read=0;
                    data_count=0;
                    cmd_count=0;
                    write=0;
                    first_data_byte=0;
                    break;
                    // Read after write
                case 'R':
                    read=1;
                    break;
                    // Status request
                case '?':
                    lcd.printf(" mbed ready \n\r");
                    break;
                    // Unknown or unimplemented command
                default:
                    lcd.printf(" unknown command \n\r");
                    break;
            }
            previous_command = last_command;
        }
    }
}