#include "mbed.h"
#include "BMP085.h"
#include "TextLCD.h"

DigitalOut myled1(LED1);
DigitalOut myled4(LED4);
BMP085 bmp085(p9, p10);
Serial pc(USBTX, USBRX);
TextLCD LCD(p15, p16, p17, p18, p19, p20,TextLCD::LCD20x4); // rs, e, d4-d7

int main()
{
    pc.printf("main\n\r");
    float p, t;

    while(1) {
        LCD.cls();
        myled1 = 1;
        myled4 = 0;
        bmp085.update();
        p = bmp085.get_pressure();
        t = bmp085.get_temperature();
        // pc.printf("Pressure %6.2f - Temperature %6.2f\n\r", p, t);
        LCD.printf("Pressure %6.2f\n", p/1000-1);
        LCD.printf("In Temp %6.2f\n", t);
        myled1 = 0;
        myled4 = 1;
        wait(1.0);
    }
}
