#include "mbed.h"
#include "serial_lcd.h"
#include "pc_uart.h"
#include "rtc.h"
#include "keypad.h"
#include "menu.h"

DigitalOut R_LED(PA_10);            // RED part of the RGB LED
DigitalOut G_LED(PB_5);             // GREEN part of the RGB LED
DigitalOut B_LED(PA_9);             // BLUE part of the RGB LED
PwmOut speaker(PB_4);               // Speaker

uint32_t Systck_cnt = 0;
uint32_t Systck_evt = 0;
uint32_t RGB_sel = 0;

extern uint32_t Index;
extern uint32_t new_key;
extern Serial pc;                   // UART to communicate with PC
extern DigitalOut myled;            // On-board LED
extern FSM_State Main_FSM_States;
extern RTC_HandleTypeDef rtch;
extern RTC_TimeTypeDef rtc_time;
extern RTC_DateTypeDef rtc_date;
extern RTC_AlarmTypeDef rtc_alarm;
extern int tmp_date, tmp_sec;
extern int AlarmA_Enabled;
extern int AlarmA_triggered;

const float scala[38] = { 0.0f, 108.0f, 112.5f, 121.5f, 129.6f, 135.0f, 144.0f, 150.0f, 162.0f, 172.8f, 180.0f, 194.4f, 202.5f,
                                216.0f, 225.0f, 243.0f, 259.2f, 270.0f, 288.0f, 300.0f, 324.0f, 345.6f, 360.0f, 388.8f, 405.0f,
                                432.0f, 450.0f, 486.0f, 518.4f, 540.0f, 576.0f, 600.0f, 648.0f, 691.2f, 720.0f, 777.6f, 810.0f,
                                864.0f };

const uint32_t song[54][2] = { {16, 4}, {18, 4}, {20, 4}, {18, 4}, {16, 2}, { 0, 2}, {16, 4}, {18, 4}, {20, 4}, {18, 4}, {16, 2}, { 0, 2}, {20, 4}, {20, 4}, {21, 4}, {21, 4},
                               {20, 4}, {20, 4}, {18, 2}, {20, 4}, {20, 4}, {21, 4}, {21, 4}, {20, 4}, {20, 4}, {18, 2}, {20, 4}, {18, 4}, {20, 4}, {21, 4}, {23, 4}, {21, 4},
                               {20, 4}, {18, 4}, {20, 4}, {18, 4}, {20, 4}, {21, 4}, {23, 4}, {21, 4}, {20, 4}, {18, 4}, {16, 4}, {18, 4}, {20, 4}, {18, 4}, {16, 2}, { 0, 2},
                               {16, 4}, {18, 4}, {20, 4}, {18, 4}, {16, 2}, { 0, 2} };

void SysTick_Handler(void) {
    HAL_SYSTICK_Callback();
}

void HAL_SYSTICK_Callback(void) {
    Systck_cnt++;
    Systck_evt++;
}

void Drive_RGB_LED(void) {
    switch (RGB_sel % 3) {
        case 0: 
            R_LED = 0;
            G_LED = 1;
            B_LED = 1;
            break;
        case 1: 
            R_LED = 1;
            G_LED = 0;
            B_LED = 1;
            break;
        case 2: 
            R_LED = 1;
            G_LED = 1;
            B_LED = 0;
            break;
        default: 
            R_LED = 1;
            G_LED = 1;
            B_LED = 1;
            break;
    }
    RGB_sel++;
}

int main() {
    uint32_t dummy;
    int i;
    float tone;

    speaker = 0;
    R_LED = 1;
    G_LED = 1;
    B_LED = 1;

    InitRTC();
    Init_keypad();

    NVIC_SetVector(SysTick_IRQn, (uint32_t)SysTick_Handler);
    HAL_SYSTICK_Config(14400000);

    __enable_irq();

    init_ser_lcd();
    write_ser_lcd(0x80, false);     // set DDRAM addr to 0x00
    write_ser_text((char *)"ARM        SKOOL",16);
    write_ser_lcd(0xC0, false);     // set DDRAM addr to 0x40, beginning of 2nd line
    write_ser_text((char *)"  Alarm  clock  ", 16);

    wait(3.0);

    write_ser_lcd(0x01, false);     // Clear display
    wait_us(1100);
    write_ser_lcd(0x06, false);     // Entry mode set
    wait_us(30);
    ShowTime();
    ShowDate();

    while (1) {
        if (new_key != 0) {
            if ((Index < 0xFF) & (Keytable[Index] == '#')) {
                Main_FSM_States = IN_MENU;
                MainMenu_Handler();
                if (Main_FSM_States == FINISH) {Main_FSM_States = IN_LOOP;}
            }
            new_key = 0;
            Index = 0xFF;
            HAL_NVIC_EnableIRQ(EXTI9_5_IRQn);
        }


        HAL_RTC_GetTime(&rtch, &rtc_time, FORMAT_BCD);
        HAL_RTC_GetDate(&rtch, &rtc_date, FORMAT_BCD);
        if (rtc_time.Seconds != tmp_sec) {
            ShowTime();
            dummy = 0;

            if (rtc_date.Date != tmp_date) {
                ShowDate();
            }
        }

        if (AlarmA_triggered) {
            AlarmA_triggered = 0;
            ShowAlarmText();
            Drive_RGB_LED();
            for (i = 0; i < 54; i++) {
                if (song[i][0] > 0.0f) {
                    tone = float(1.0f/scala[song[i][0]]);
                    speaker.period(tone);
                    speaker = 0.5;
                } else {
                    speaker = 0;
                }
                wait(float(1.0f/song[i][1]));
                if ((new_key != 0) & (Index < 0xFF) & (Keytable[Index] == '#')) {
                    speaker = 0;
                    i = 54;
                    new_key = 0;
                    Index = 0xFF;
                    HAL_NVIC_EnableIRQ(EXTI9_5_IRQn);
                }
                Drive_RGB_LED();
            }
            write_ser_lcd(0x01, false);     // Clear display
            wait_us(1100);
            write_ser_lcd(0x06, false);     // Entry mode set
            wait_us(30);
            ShowTime();
            ShowDate();
            R_LED = 1;
            G_LED = 1;
            B_LED = 1;
        }

        if (Systck_cnt > 5) {
            Systck_cnt = 0;
        }
        //HAL_PWR_EnterSLEEPMode(PWR_MAINREGULATOR_ON, PWR_SLEEPENTRY_WFI);
        __WFI();
        //while (Systck_evt == 0) {
        //    dummy++;
        //}
        Systck_evt = 0;
    }
}
