#ifndef SERIAL_LCD_H
#define SERIAL_LCD_H

#include "mbed.h"

#define PCF8574_ADDR            0x4E
#define ST7032I_ADDR            0x7C

#define FUNC_SET                0x28
#define CLEAR_DISP              0x01
#define RET_HOME                0x02
#define ENTRY_MODE              0x06        // Increment; no Shift
#define DISPLAY_ON_OFF          0x0F        // Display ON; Cursor ON; Blink ON
#define CG_ADDR                 0x40        // add ACG5:ACG0
#define DD_ADDR                 0x80        // add ADD6:ADD0

#define BL_ON                   0x08
#define BL_OFF                  0x00
#define ENABLE                  0x04
#define DISABLE                 0x00
#define READ                    0x02
#define WRITE                   0x00
#define DATA                    0x01
#define INSTRUCTION             0x00

#define BL                      BL_ON

int init_ser_lcd(void);
int write_ser_lcd(char data, bool mode);
void write_ser_text(const char* text, uint32_t len);

#endif
