#include "mbed.h"
#include "serial_lcd.h"
#include "pc_uart.h"

I2C i2c1(I2C_SDA, I2C_SCL);         // I2C interface for LCD display
DigitalOut LCD_RST(PB_10);          // LCD RST
DigitalOut LCD_BL(PA_8);            // LCD BackLight

#define NUM_USER_CHARS              2

const char CGData[NUM_USER_CHARS][8] = {{0x0A,0x0A,0x00,0x0E,0x11,0x11,0x0E,0x00},
                                        {0x04,0x0E,0x0E,0x1F,0x1F,0x1F,0x04,0x00}};

void write_ser_CGdata(void) {
    int i;
    
    write_ser_lcd(0x38, false);
    wait_us(30);
    write_ser_lcd(0x40, false);
    wait_us(30);
    for (i = 0; i < NUM_USER_CHARS; i++) {
        write_ser_text(CGData[i], 8);
    }
}

int write_ser_lcd(char data, bool mode) {
    char wd[2];
    int status;

    wd[0] = ((mode) ? 0x40 : 0x00);
    wd[1] = (char)data;
    status = i2c1.write(ST7032I_ADDR, wd, 2, false);
    return status;
}

void write_ser_text(const char* text, uint32_t len) {
    int i;
    char wd[41];
    int status;

    wd[0] = 0x40;
    for (i = 0; i < len; i++) {
        wd[i + 1] = text[i];
    }
    status = i2c1.write(ST7032I_ADDR, wd, len + 1, false);
    if (status != 0) {
        Error(0);
    }
}

int init_ser_lcd(void) {
    int status;

    LCD_RST = 0x0;                  // Generating Reset pulse
    LCD_BL = 0x0;                   // BackLight off
//    BL_LCD = 0.0;
    wait_us(200);
    LCD_RST = 0x1;
    wait_ms(40);
    status = write_ser_lcd(0x38, false);     // Function set with IS = 0
    if (status != 0) {
        Error(0);
    }
    wait_us(30);
    status = write_ser_lcd(0x10, false);     // Cursor or display shift S/C = 0 - cursor
    if (status != 0) {
        Error(0);
    }
    wait_us(30);
    status = write_ser_lcd(0x39, false);     // Function set with IS = 1
    if (status != 0) {
        Error(0);
    }
    wait_us(30);
    status = write_ser_lcd(0x14, false);     // Internal OSC frequency adjustment
    if (status != 0) {
        Error(0);
    }
    wait_us(30);
    status = write_ser_lcd(0x79, false);     // Contrast set
    if (status != 0) {
        Error(0);
    }
    wait_us(30);
    status = write_ser_lcd(0x5C, false);     // Power/Icon/Contrast control
    if (status != 0) {
        Error(0);
    }
    wait_us(30);
    status = write_ser_lcd(0x6E, false);     // Follower control
    if (status != 0) {
        Error(0);
    }
    wait_ms(200);
//    wait_us(30);
    status = write_ser_lcd(0x0C, false);     // Display ON
    if (status != 0) {
        Error(0);
    }
    wait_us(30);
    status = write_ser_lcd(0x01, false);     // Clear display
    if (status != 0) {
        Error(0);
    }
    wait_us(30);
    status = write_ser_lcd(0x06, false);     // Entry mode set
    if (status != 0) {
        Error(0);
    }
    wait_us(30);
    status = write_ser_lcd(0x02, false);     // Home
    if (status != 0) {
        Error(0);
    }
    wait_us(30);
    write_ser_CGdata();
    LCD_BL = 0x1;                   // BackLight ON
//    BL_LCD = 0.5;
    return 0;
}
