#include "mbed.h"
#include "pc_uart.h"

Serial pc(SERIAL_TX, SERIAL_RX);    // UART to communicate with PC
DigitalOut myled(LED1);             // On-board LED

void Error(int err) {
    switch (err) {
        case 0: pc.printf("\033[44m\033[37mI2C communication error!\033[00m\r\n");
        break;
        case 1: pc.printf("\033[44m\033[37mIncorrect calibration data error!\033[00m\r\n");
        break;
        default: pc.printf("\033[44m\033[37mUnknown error!\033[00m\r\n");
        break;
    }
    while (1) {
        myled = 1;
        wait(0.1);
        myled = !myled;
        wait(0.1);
        myled = !myled;
        wait(0.1);
        myled = !myled;
        wait(2);
    }
}
