#include "menu.h"
#include "serial_lcd.h"
#include "keypad.h"
#include "rtc.h"

const char MAINMENU_ITEMS[4][16] = {{0x90,'b','r','e','s','z','t',0x82,'s',' ','k','i','/','b','e',' '},//"Ébresztés ki/be "},
                                    {'I','d',0x00,' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '},//"Ido             "},
                                    {0x90,'b','r','e','s','z','t',0x82,'s',' ',' ',' ',' ',' ',' ',' '},//"Ébresztés       "},
                                    {'D',0xE0,'t','u','m',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '}};//"Dátum           "}};
const char MAINMENU_2NDLINE[16] =   {' ',' ',' ',' ',' ',' ',' ','b','e',0xE0,'l','l',0xE1,'t',0xE0,'s'};//"       beállítás"};
const char ALARM_A_TEXT[16] = {' ',' ',' ',0xFB,0x90,'b','r','e','s','z','t',0x00,0xFC,' ',' ',' '};//"<Ébreszto>"
volatile FSM_State Main_FSM_States = IN_LOOP;
volatile int MainMenu_CurrentItem = 0;
extern int AlarmA_Enabled;

void ShowMainMenuItem(int ItemNr) {
    write_ser_lcd(0x01, false);     // Clear display
    wait_us(1100);
    write_ser_lcd(0x06, false);
    wait_us(30);
    write_ser_lcd(0x80, false);     // Move address to beginning of first line
    wait_us(30);
    write_ser_text(MAINMENU_ITEMS[ItemNr], 16);
    if (ItemNr > 0) {
        write_ser_lcd(0xC0, false);     // Move address to beginning of second line
        write_ser_text(MAINMENU_2NDLINE, 16);
    }
}

void ExecuteMainMenuItem(int ItemNr) {
    switch (ItemNr) {
        case 0: Main_FSM_States = ALARM_ON_OFF;
                if (AlarmA_Enabled == 0) {
                    AlarmA_Enable();
                } else AlarmA_Disable();
                break;
        case 1: Main_FSM_States = SET_TIME;
                SetRTCTime();
                break;
        case 2: Main_FSM_States = SET_ALARM;
                SetRTCAlarm();
                break;
        case 3: Main_FSM_States = SET_DATE;
                SetRTCDate();
                break;
        default: break;
    }
}

void MainMenu_Handler(void) {
    int keypress;
    int isexit = 0;

    MainMenu_CurrentItem = 0;
    ShowMainMenuItem(MainMenu_CurrentItem);
    while ((isexit == 0) & (Main_FSM_States != FINISH)) {
        keypress = Poll_keypad_vert();
        switch (keypress) {
            case 0x01:  MainMenu_CurrentItem = ((MainMenu_CurrentItem == 0) ? 0 : MainMenu_CurrentItem - 1);
                        ShowMainMenuItem(MainMenu_CurrentItem);
                        break;
            case 0x05:  ExecuteMainMenuItem(MainMenu_CurrentItem);
                        isexit = 1;
                        break;
            case 0x09:  MainMenu_CurrentItem = ((MainMenu_CurrentItem == MAINMENU_ITEMMAX - 1) ? MAINMENU_ITEMMAX - 1 : MainMenu_CurrentItem + 1);
                        ShowMainMenuItem(MainMenu_CurrentItem);
                        break;
            case 0x0E:  isexit = 1;
                        Main_FSM_States = FINISH;
                        break;
            default:    break;
        }
    }
    write_ser_lcd(0x01, false);
    wait_us(1100);
    write_ser_lcd(0x06, false);
    wait_us(30);
    write_ser_lcd(0x0C, false);
    wait_us(30);
    ShowTime();
    ShowDate();
    HAL_GPIO_WritePin(GPIOC, cols[0] | cols[1] | cols[2], GPIO_PIN_SET);
    HAL_GPIO_WritePin(GPIOC, cols[2], GPIO_PIN_RESET);
    Main_FSM_States = IN_LOOP;
}

void ShowAlarmText(void) {
    write_ser_lcd(0x01, false);     // Clear display
    wait_us(1100);
    write_ser_lcd(0x06, false);     // Entry mode set
    wait_us(30);
    write_ser_lcd(0x80, false);     // set DDRAM addr to 0x00, beginning of 1st line
    wait_us(30);
    write_ser_text(ALARM_A_TEXT, 16);
}
