#ifndef KEYPAD_H
#define KEYPAD_H

#include "mbed.h"

// Define your own keypad values
const char Keytable[] = { '1', '2', '3', 'A',   // r0
                          '4', '5', '6', 'B',   // r1
                          '7', '8', '9', 'C',   // r2
                          '*', '0', '#', 'D'    // r3
                        };
                        // c0   c1   c2   c3
const uint16_t rows[4] = {GPIO_PIN_5, GPIO_PIN_6, GPIO_PIN_8, GPIO_PIN_9};
const uint16_t cols[4] = {GPIO_PIN_10, GPIO_PIN_11, GPIO_PIN_12, 0xFFFF};
//const int nrows = 4;
const int ncols = 3;

void EXTI9_5_IRQHandler(void);
void HAL_GPIO_EXTI_Callback(uint16_t pin);
void Init_keypad(void);
int Poll_keypad_vert(void);
int Poll_keypad_yesno(void);
int Poll_keypad_full(void);

#endif
