#include "mbed.h"
#include "serial_lcd.h"
#include "pc_uart.h"
#include "keypad.h"

PwmOut speaker(PB_4);               // Speaker
extern uint32_t Index;
extern uint32_t new_key;

int main()
{
    int key;
    int prev_key = 0;

    Init_keypad();
    init_ser_lcd();
    write_ser_lcd(0x80, false);     // set DDRAM addr to 0x00, beginning of 1st line
    wait_us(30);

    speaker.period((float)(1.0f/432.0f));

    while (1) {

        key = Poll_keypad_full();
        speaker = 0.5;
        wait(0.1);
        speaker = 0;
        write_ser_lcd((char)key,true);
        if (key == '*') {
            if (prev_key == '*') {
                write_ser_lcd(0xC0, false);
            }
        }
        if (key == '#') {
            if (prev_key == '#') {
                write_ser_lcd(0x01, false);     // Clear display
                wait_us(1100);
                write_ser_lcd(0x06, false);     // Entry mode set
                wait_us(30);
                write_ser_lcd(0x0C, false);     // Display ON, Cursor OFF, Blink OFF
                wait_us(30);
                write_ser_lcd(0x80, false);     // set DDRAM addr to 0x00, beginning of 1st line
                wait_us(30);
            }
        }

        prev_key = key;

    }
}

