#include "mbed.h"

PwmOut speaker(PB_4);               // Speaker
DigitalOut myled(PA_10);

const float scala[38] = { 0.0f, 108.0f, 112.5f, 121.5f, 129.6f, 135.0f, 144.0f, 150.0f, 162.0f, 172.8f, 180.0f, 194.4f, 202.5f,
                                216.0f, 225.0f, 243.0f, 259.2f, 270.0f, 288.0f, 300.0f, 324.0f, 345.6f, 360.0f, 388.8f, 405.0f,
                                432.0f, 450.0f, 486.0f, 518.4f, 540.0f, 576.0f, 600.0f, 648.0f, 691.2f, 720.0f, 777.6f, 810.0f,
                                864.0f };

const uint32_t song[54][2] = { {16, 4}, {18, 4}, {20, 4}, {18, 4}, {16, 2}, { 0, 2}, {16, 4}, {18, 4}, {20, 4}, {18, 4}, {16, 2}, { 0, 2}, {20, 4}, {20, 4}, {21, 4}, {21, 4},
                               {20, 4}, {20, 4}, {18, 2}, {20, 4}, {20, 4}, {21, 4}, {21, 4}, {20, 4}, {20, 4}, {18, 2}, {20, 4}, {18, 4}, {20, 4}, {21, 4}, {23, 4}, {21, 4},
                               {20, 4}, {18, 4}, {20, 4}, {18, 4}, {20, 4}, {21, 4}, {23, 4}, {21, 4}, {20, 4}, {18, 4}, {16, 4}, {18, 4}, {20, 4}, {18, 4}, {16, 2}, { 0, 2},
                               {16, 4}, {18, 4}, {20, 4}, {18, 4}, {16, 2}, { 0, 2} };


int main() {
    float tone;
    int i;
    
    myled = 1;

    for (i = 0; i < 54; i++) {
        if (song[i][0] > 0.0f) {
            tone = float(1.0f/scala[song[i][0]]);
            speaker.period(tone);
            speaker = 0.5;
        } else {
            speaker = 0;
        }
        wait(float(1.0f/song[i][1]));
    }
    while (1) {
        myled = 0; // LED is ON
        wait(0.2); // 200 ms
        myled = 1; // LED is OFF
        wait(1.0); // 1 sec
    }

}
    