#include "mbed.h"

#define botonPulsado 0
#define botonNoPulsado 1
#define tiempoMaximo 0.5


Serial pc(USBTX, USBRX); // tx, rx

DigitalOut led(LED1);
DigitalIn boton(USER_BUTTON);
Timer temporizador;
enum estados {esperandoPulsacion,esperandoSoltarBoton, esperandoSegundaPulsacion,esperandoSoltarSegundaPulsacion};
estados estado;


void funcionEsperandoPulsacion()
{
    if(boton==botonPulsado) {
        temporizador.reset();
        temporizador.start();
        estado=esperandoSoltarBoton;
        pc.printf("Boton pulsado\n");
    }
}

void funcionEsperandoSoltarBoton()
{
    if(boton==botonNoPulsado) {
        estado=esperandoSegundaPulsacion;
        pc.printf("Boton soltado\n");
    }
}

void funcionEsperandoSegundaPulsacion()
{
    if(temporizador.read()>tiempoMaximo) {
        estado=esperandoPulsacion;
        pc.printf("Emporizador expirado\n");
    } else if(boton==botonPulsado) {
        led=!led;
        estado=esperandoSoltarSegundaPulsacion;
        pc.printf("Doble Click\n");
    }
}

void funcionEsperandoSoltarSegundaPulsacion()
{
    if(boton==botonNoPulsado) {
        estado=esperandoPulsacion;
        pc.printf("Boton soltado Segunda pulsacion\n");
    }
}

int main()
{
    pc.baud(115200);
    estado=esperandoPulsacion;
    while(1) {
        switch(estado) {
            case esperandoPulsacion:
                funcionEsperandoPulsacion();
                break;
            case esperandoSoltarBoton:
                funcionEsperandoSoltarBoton();
                break;
            case esperandoSegundaPulsacion:
                funcionEsperandoSegundaPulsacion();
                break;
            case esperandoSoltarSegundaPulsacion:
                funcionEsperandoSoltarSegundaPulsacion();
                break;
        }
    }
}
