#ifndef MBED_LEDSETUP_H
#define MBED_LEDSETUP_H

#include "mbed.h"

class LedSetup
{
public:
    LedSetup(PinName redPin, PinName greenPin, PinName bluePin);
    void init();
    bool LEDManual(float R, float G, float B);
    bool LEDColor(char C);
    void ColorLEDRandom();
    float RetEstado(int numero);
    void LEDEstado(bool b);
    
private:
    //DigitalOut gpo;//(D0);
    DigitalOut ledR;//(LED_RED);
    DigitalOut ledG;//(LED_GREEN);
    DigitalOut ledB;//(LED_BLUE);
    float Estado[3];
};

//mbed.h por su cuenta tiene la lista de pines para el LED segun la plaqueta

//float Estado[3] = {1.0f, 1.0f, 1.0f};
/*
bool LEDManual(float R, float G, float B) {
    if ((R <= 1.0f) && (G <= 1.0f) && (B <= 1.0f) && (R >= 0.0f) && (G >= 0.0f) && (B >= 0.0f)){
        ledR = R;
        ledG = G;
        ledB = B;
        
        Estado[0] = ledR;
        Estado[1] = ledG;    
        Estado[2] = ledB; 
        return true;
    } else {
        LEDManual(Estado[0], Estado[1], Estado[2]);
        return false;
    }
} 

bool LEDColor(char C) {
    bool b = true;
    
    switch (C) {
    case 'R':
        LEDManual(0.0f, 1.0f, 1.0f);
        break;
    case 'G':
        LEDManual(1.0f, 0.0f, 1.0f);
        break;
    case 'B':
        LEDManual(1.0f, 1.0f, 0.0f);
        break;
    case 'Y':
        LEDManual(0.0f, 0.0f, 1.0f);
        break;
    case 'M':
        LEDManual(0.0f, 1.0f, 0.0f);
        break;
    case 'C':
        LEDManual(1.0f, 0.0f, 0.0f);
        break;
    case 'W':  
        LEDManual(0.0f, 0.0f, 0.0f);
        break;
    default:
        b = false;
        break;        
    }
    
    if (b) {
        Estado[0] = ledR;
        Estado[1] = ledG;
        Estado[2] = ledB;    
    }
    
    return b;
}


void ColorLEDRandom() {
   //Deberia devolver un numero random entre 0 y 10, y dividirlo por 10 para 
   //obtener un valor entre 0.0 y 1.0 para asignar a los distintos LED
   Estado[0] = ((rand() % 11) / 10.0);
   Estado[1] = ((rand() % 11) / 10.0);
   Estado[2] = ((rand() % 11) / 10.0);
   
   ledR = Estado[0];
   ledG = Estado[1];
   ledB = Estado[2];
   
}

//C no puede devolver arreglos, asi que para no jugar con los punteros por no
//poder probar con la plaqueta, agrego una funcion que devuelven los valores
//de "Estado" como floats individualmente
float RetEstado(int numero) {
    switch(numero) {
        case 0:
            return Estado[0];
        case 1:
            return Estado[1];
        case 2:
            return Estado[2];
        default:
            return -1.0;
    }
}

void LEDEstado(bool b) {
    if (b) { 
        LEDManual(Estado[0], Estado[1], Estado[2]);          
    } else {
        ledR = 1.0f;
        ledG = 1.0f;
        ledB = 1.0f;
    }
}
 */

#endif
