#include "LedSetup.h"

LedSetup::LedSetup(PinName redPin, PinName greenPin, PinName bluePin) : ledR(redPin), ledG(greenPin), ledB(bluePin)
{
}

void LedSetup::init()
{
    //m_red.period(0.001);
    Estado[0] = 1.0f;
    Estado[1] = 1.0f;
    Estado[2] = 1.0f;
}


bool LedSetup::LEDManual(const float R, const float G, const float B) {
    if ((R <= 1.0f) && (G <= 1.0f) && (B <= 1.0f) && (R >= 0.0f) && (G >= 0.0f) && (B >= 0.0f)){
        ledR = R;
        ledG = G;
        ledB = B;
        
        Estado[0] = ledR;
        Estado[1] = ledG;    
        Estado[2] = ledB; 
        return true;
    } else {
        LEDManual(Estado[0], Estado[1], Estado[2]);
        return false;
    }
} 

bool LedSetup::LEDColor(char C) {
    bool b = true;
    
    switch (C) {
    case 'R':
        LEDManual(0.0f, 1.0f, 1.0f);
        break;
    case 'G':
        LEDManual(1.0f, 0.0f, 1.0f);
        break;
    case 'B':
        LEDManual(1.0f, 1.0f, 0.0f);
        break;
    case 'Y':
        LEDManual(0.0f, 0.0f, 1.0f);
        break;
    case 'M':
        LEDManual(0.0f, 1.0f, 0.0f);
        break;
    case 'C':
        LEDManual(1.0f, 0.0f, 0.0f);
        break;
    case 'W':  
        LEDManual(0.0f, 0.0f, 0.0f);
        break;
    default:
        b = false;
        break;        
    }
    
    if (b) {
        Estado[0] = ledR;
        Estado[1] = ledG;
        Estado[2] = ledB;    
    }
    
    return b;
}


void LedSetup::ColorLEDRandom() {
   //Deberia devolver un numero random entre 0 y 10, y dividirlo por 10 para 
   //obtener un valor entre 0.0 y 1.0 para asignar a los distintos LED
   Estado[0] = ((rand() % 11) / 10.0);
   Estado[1] = ((rand() % 11) / 10.0);
   Estado[2] = ((rand() % 11) / 10.0);
   
   ledR = Estado[0];
   ledG = Estado[1];
   ledB = Estado[2];
   
}

//C no puede devolver arreglos, asi que para no jugar con los punteros por no
//poder probar con la plaqueta, agrego una funcion que devuelven los valores
//de "Estado" como floats individualmente
float LedSetup::RetEstado(int numero) {
    switch(numero) {
        case 0:
            return Estado[0];
        case 1:
            return Estado[1];
        case 2:
            return Estado[2];
        default:
            return -1.0;
    }
}

void LedSetup::LEDEstado(bool b) {
    if (b) { 
        LEDManual(Estado[0], Estado[1], Estado[2]);          
    } else {
        ledR = 1.0f;
        ledG = 1.0f;
        ledB = 1.0f;
    }
}
