#include "mbed.h"
#include "SDFileSystem.h"
#include "LedSetup.h"


DigitalIn sw2(SW2);
DigitalIn sw3(SW3);
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");
FILE *fp;

int EstadoAntBTN2 = 1;
int EstadoAntBTN3 = 1;

LedSetup leds(LED_RED, LED_GREEN, LED_BLUE);

bool valorLED = false;

//Prende/Apaga el LED
int Boton2() {
    int retorno;
    if (sw2 == 0) {        
        if (valorLED) {
            leds.LEDEstado(false);
            retorno = 0;
        } else {
            leds.LEDEstado(true);
            retorno = 1;
        }
        valorLED = !valorLED;
    } else {
        retorno = -1;
    }
    return retorno;
}

//Setea el color del LED al azar
bool Boton3() {
    if (sw3 == 0) {
        leds.ColorLEDRandom();
        return true;
    } else {
        return false;
    }
}

//No lo cierra porque se va a usar permanentemente
void CrearArchivo() {
    mkdir("/sd", 0777);
    fp = fopen("/sd/log.txt", "w");
}

int main() {
    printf("Inicio");
        
    CrearArchivo();  
    printf("Archivo creado");  
    while (true) {
        printf("Loop");
        if ((sw2 == 0) and (EstadoAntBTN2 == 1)){
            printf("Estado Boton 2");
            if ((Boton2()) == 1) {   
                fprintf(fp, "Se prendio el LED! (Boton 2)\n");
                printf("LED ON\n");
            } else if ((Boton2()) == 0){
                fprintf(fp, "Se apago el LED (Boton 2)\n");
                printf("LED OFF\n");
            }
            EstadoAntBTN2 = 0;
        }
        if (sw2 == 1) {
            printf("Reset de estado de boton 2");
            EstadoAntBTN2 = 1;
        }
            
        if ((sw3 == 0) and (EstadoAntBTN3 == 1)) {
            printf("Estado de boton 3");
            if (Boton3()) {
                fprintf(fp, "Se cambio el color aleatoriamente! (Boton 3)\n");
                printf("LED: COLOR RANDOM\n");
            }
            EstadoAntBTN3 = 0;
        }
        if (sw3 == 1) {
            printf("Reset de estado de boton 3");
            EstadoAntBTN3 = 1;
        }
    }  
}
    