#include "antirrebote.h"

enum {PRESS=0, NO_PRESS=1, S_NO_PRESS, S_DETECT_PULS, S_DEB1, S_PRESS, S_RETENTION, S_DEB2, DEB_TIME = 20};

AntReb::~AntReb()
{
}
AntReb::AntReb()
{
    state = S_NO_PRESS;
    deb_time = DEB_TIME;
    hab=0;
    out=0;
}

void AntReb::setPin(DigitalIn pin)
{
    Pulsador = pin.read();
}
void AntReb::DebTime()
{
    if(deb_time>0)
        deb_time--;
    else
        deb_time = DEB_TIME;
}

pinEstado_t AntReb::antiRebote()
{

    switch(state) {
        case S_NO_PRESS:
        default:
            if (Pulsador == PRESS) {
                 state = S_DETECT_PULS;
            }
        break;
        
        case S_DETECT_PULS:
            if (Pulsador == PRESS && deb_time < 20){
                hab=1;
                state = S_DEB1;
            } else if(Pulsador == NO_PRESS)
                state = S_NO_PRESS;
            break;

        case S_DEB1:
            if (deb_time == 0 && hab == 1) {
                state = S_PRESS;
                hab=0;

            }
            break;

        case S_PRESS:
            out = 1;
            state= S_RETENTION;
            break;

        case S_RETENTION:
            out = 0;
            if (Pulsador == NO_PRESS)
                state = S_DEB2;
            break;

        case S_DEB2:
            if (deb_time == 20)
                hab=1;
            else if (deb_time == 0 && hab == 1) {
                state = S_NO_PRESS;
                hab=0;
            }
            break;
    }
    return out;
}

