#include "mbed.h"
//Al tocar pulsador. secuencia de led titilante activada. si se vuelve a tocar el pulsador. se apaga el led

enum {ON=0, OFF=1, COMP=1, INC=0, S_OFF=0, S_WAIT, S_ON, S_OUT=0, S_LON, S_LOFF}; 

DigitalOut LedRojo(LED1);
DigitalIn Puls(PTB8);
Ticker wait_puls;
Ticker wait_led;
 
void SM_ANTI_REBOTE();
void SM_BLINKING_LED();
void interrupt_puls();
void interrupt_led();
int blink = OFF, state_pul=0, state_b, timeP_complete=INC, timeL_complete=INC;

int main(void)
{
    wait_puls.attach(&interrupt_puls,0.1);    
    wait_led.attach(&interrupt_led,0.5);
    while(true)
    {
        SM_ANTI_REBOTE();
        SM_BLINKING_LED();        
    }          
}

void SM_ANTI_REBOTE(void)
{
    switch (state_pul)
    {    
        case S_OFF://Estado en el cual el led esta apagado y el pulsador no esta presionado.
            blink=OFF;
            if(Puls == ON)//Si detecta un pulso bajo en el pulsador(este tiene una configuracion pull-up) 
                state_pul=S_WAIT;
        break;
            
        case S_WAIT://Estado para evitar el rebote del pulsador
            if(timeP_complete == COMP && Puls == ON && blink==OFF)//Evalua si se está dando inicio a la secuencia...   
            {
                state_pul = S_ON;
                timeP_complete=INC;
            }
            else if(timeP_complete == COMP && Puls == ON && blink==ON)//...o si se esta finalizando 
            {
                state_pul = S_OFF; 
                timeP_complete=INC;        
            }
        break;
        
        case S_ON://Estado en el cual el led esta parpadeando y el pulsador no esta presionado.
            blink = ON;
            if(Puls == ON)
                state_pul=S_WAIT;
        break;                  
}
}
void SM_BLINKING_LED()
{
    switch (state_b)
    {    
        case S_OUT://Estado en el que espera que se pulse el pulsador para dar inicio a la secuencia. Led apagado
            LedRojo=OFF;
            if(blink==ON)
                state_b = S_LON;
        break;
    
        case S_LON://El led se prende medio segundo
            LedRojo = ON;
            if (timeL_complete == COMP)
            {
                state_b=S_LOFF;
                timeL_complete=INC;
            }
            else if (blink==OFF)
                state_b = S_OUT;
        break;
    
        case S_LOFF://El led se apaga medio segundo
            LedRojo = OFF;
            if (timeL_complete == COMP)
            {
                state_b=S_LON;
                timeL_complete=INC;
            }
            else if (blink==OFF)
                state_b = S_OUT;
        break;    
}
}        
void interrupt_led()
{
timeL_complete=COMP;
}

void interrupt_puls()
{
timeP_complete = COMP;   
}