#include "mbed.h"
#include "WIZnetInterface.h"
 
#define MY_DEFAULT_IP_ADDR        "10.51.23.95" //IP per comunicare con Siren: 10.51.23.95 - ".95" settabile con Dipswitch 
#define MY_DEFAULT_MASK           "255.255.255.0"
#define MY_DEFAULT_GATEWAY        "10.51.23.254" //Default Gateway della STM32

//new server windows 2012 ctosw00014.cto.st.com
#define SIREN_SERVER_NAME   "10.51.37.30"
#define SIREN_SERVER_PORT   8897

const char * IP_Addr    = "10.51.23.95";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "10.51.23.254";

unsigned char MAC_Addr[6] = {0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED};
SPI spi(PA_7,PA_6,PA_5); //MOSI, MISO, SCK
WIZnetInterface ethernet(&spi,PB_6,PA_10);
DigitalOut cs(D10);
DigitalOut reset(D2);

int main() {
    reset = 0;
    printf("Start4\r\n");
    TCPSocketConnection();
    int ret = ethernet.init(MAC_Addr,"10.51.23.95",IP_Subnet,IP_Gateway);
        
    if(!ret){
        printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
        ret = ethernet.connect();
        if(!ret){
            printf("IP: %s, MASK: %s, GW: %s\r\n",
                      ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
        }else{
            printf("Error ethernet.connect() - ret = %d\r\n", ret);
        }
    }else{
        printf("Error ethernet.init() - ret = %d\r\n", ret);
    }
    while(true);   
}