#include "mbed.h"
#include "TCPSocket.h"
#include "EthernetInterface.h"

#define MY_DEFAULT_IP_ADDR        "10.51.23." 
#define MY_DEFAULT_MASK           "255.255.255.0"
#define MY_DEFAULT_GATEWAY        "10.51.23.254"

#define MESSAGE_RUN      "RUN"
#define MESSAGE_IDLE     "IDLE"

//new server windows 2012 ctosw00014.cto.st.com
#define SIREN_SERVER_NAME   "10.51.37.30"
#define SIREN_SERVER_PORT   8897

#define LWIP_ICMP               1 
#define MEMP_NUM_SYS_TIMEOUT        16

#if defined(TARGET_ARCH_MAX)
#define CHECKSUM_GEN_ICMP           0
#endif

#if !CHECKSUM_GEN_ICMP
    iecho->chksum = 0;
#endif 

DigitalIn bit0(D9);
DigitalIn bit1(D8);
DigitalIn bit2(D7);
DigitalIn bit3(D6);
DigitalIn bit4(D5);
DigitalIn bit5(D4);
DigitalIn bit6(D3);
DigitalIn bit7(D2);

DigitalIn configurazione_rele(PB_11); //NO - 1, NC - 0
DigitalIn rele_ventola(PB_10);
DigitalIn semaforo_1(PE_10);
DigitalIn semaforo_2(PE_12);
DigitalIn semaforo_3(PE_14);
DigitalIn semaforo_4(PE_15);
DigitalIn alimentazione(PE_7);

EthernetInterface eth;
TCPSocket socket;

int main()
{
    char ip_scheda[100];
    int val = (1*bit0.read())+(2*bit1.read())+(4*bit2.read())+(8*bit3.read())+(16*bit4.read())+(32*bit5.read())+(64*bit6.read())+(128*bit7.read());
    sprintf(ip_scheda, "%s%d",MY_DEFAULT_IP_ADDR,val);

    eth.set_network(ip_scheda, MY_DEFAULT_MASK, MY_DEFAULT_GATEWAY);
    eth.connect();
    const char *ip = eth.get_ip_address();
    printf("IP address is: %s\n\r", ip ? ip : "No IP");
    
    while(true)
        printf("valore: %d\n\r", rele_ventola.read());

    // Open a socket on the network interface, and create a TCP connection to mbed.org
    socket.open(&eth);
    socket.connect(SIREN_SERVER_NAME, SIREN_SERVER_PORT);

    // Send a simple http request
    char sbuffer[] = "alarm";
    int scount = socket.send(sbuffer, sizeof sbuffer);
    printf("sent %d [%.*s]\r\n", scount, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);

    // Close the socket to return its memory and bring down the network interface
    socket.close();
    eth.disconnect();

    printf("Done\n");
}

