/***************************************************************************//**
 * @file settings.h
 * @settings file for Hungry Gecko program
 ******************************************************************************/
#ifndef SETTINGS_H_
#define SETTINGS_H_
#include "LCDSettings.h"

#define MAXLENGTH 255
#define STEPSIZE 7

/*  Define board limits, note that the display height and display width is 128
 * This particlular choice leads to 255 STEPSIZE x STEPSIZE tiles. Thus,
 * the tile number can be stored in 1 uint8_t
 * */
#define TOPEDGE 2
#define BOARD_HEIGHT 15
#define BOARD_WIDTH 17
#define BOARDERWIDTH (DISPLAY_WIDTH - STEPSIZE*BOARD_WIDTH)

/* Define allowed direction to move */
typedef enum{
    LEFT=0, RIGHT, UP, DOWN
} Direction;

#endif /* SETTINGS_H_ */

