/***************************************************************************//**
 * @file asymmetricPart.cpp
 * @brief class for an asymmetric head object for gecko.h
 *******************************************************************************
 * @section License
 * <b>(C) Copyright 2015 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/
#include "asymmetricPart.h"

asymmetricPart::asymmetricPart(): _px_map(NULL), _nPix(0){
	_posAndDir.x = 0;
	_posAndDir.y = 0;
	_posAndDir.direction = UP;
}

asymmetricPart::asymmetricPart(uint8_t x, uint8_t y, Direction dir, const uint8_t *px_map, uint8_t nPix): _px_map(px_map), _nPix(nPix){
	_posAndDir.x = x;
	_posAndDir.y = y;
	_posAndDir.direction = dir;
}

void asymmetricPart::init(uint8_t x, uint8_t y, Direction dir,  const uint8_t *px_map, uint8_t nPix){
	_posAndDir.x = x;
	_posAndDir.y = y;
	_posAndDir.direction = dir;
	_px_map = px_map;
	_nPix = nPix;
}

void asymmetricPart::draw(silabs::LS013B7DH03 &display, uint8_t color) const{
	switch (_posAndDir.direction){
	case UP:
		for (uint8_t i=0;i<_nPix;i++){
				display.pixel(_posAndDir.x*STEPSIZE + BOARDERWIDTH/2 +  static_cast<uint8_t>(_px_map[i] & 0xF), \
						(_posAndDir.y+TOPEDGE)*STEPSIZE + BOARDERWIDTH/2 + static_cast<uint8_t>( (_px_map[i] >> 4) & 0xF), color);
			}
		break;

	case DOWN:
		for (uint8_t i=0;i<_nPix;i++){
			display.pixel(_posAndDir.x*STEPSIZE +  BOARDERWIDTH/2 + static_cast<uint8_t>(_px_map[i] & 0xF), \
					(_posAndDir.y+TOPEDGE)*STEPSIZE + BOARDERWIDTH/2 + STEPSIZE-1-static_cast<uint8_t>( (_px_map[i] >> 4) & 0xF), color);
		}
		break;
	case RIGHT:
		for (uint8_t i=0;i<_nPix;i++){
			display.pixel(_posAndDir.x*STEPSIZE + BOARDERWIDTH/2 + STEPSIZE-1-static_cast<uint8_t>((_px_map[i] >> 4) & 0xF), \
					(_posAndDir.y+TOPEDGE)*STEPSIZE + BOARDERWIDTH/2 + static_cast<uint8_t>(_px_map[i] & 0xF), color);
		}
		break;
	case LEFT:
		for (uint8_t i=0; i<_nPix; i++){
			display.pixel(_posAndDir.x*STEPSIZE +  BOARDERWIDTH/2 + static_cast<uint8_t>((_px_map[i] >> 4) & 0xF), \
					(_posAndDir.y+TOPEDGE)*STEPSIZE + BOARDERWIDTH/2 + static_cast<uint8_t>(_px_map[i] & 0xF), color);
		}
		break;
	}
}

