/**************************************************************************//**
 * @file
 * @brief Segment LCD Config for the EFM32 Tiny Gecko STK (STK_3300)
 * @version 3.20.5
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2014 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef __SEGMENTLCDCONFIG_H
#define __SEGMENTLCDCONFIG_H

#include "em_lcd.h"

#ifdef __cplusplus
extern "C" {
#endif

/** Range of symbols available on display */
typedef enum {
    LCD_SYMBOL_GECKO,
    LCD_SYMBOL_ANT,
    LCD_SYMBOL_PAD0,
    LCD_SYMBOL_PAD1,
    LCD_SYMBOL_EFM32,
    LCD_SYMBOL_MINUS,
    LCD_SYMBOL_COL3,
    LCD_SYMBOL_COL5,
    LCD_SYMBOL_COL10,
    LCD_SYMBOL_DEGC,
    LCD_SYMBOL_DEGF,
    LCD_SYMBOL_DP2,
    LCD_SYMBOL_DP3,
    LCD_SYMBOL_DP4,
    LCD_SYMBOL_DP5,
    LCD_SYMBOL_DP6,
    LCD_SYMBOL_DP10,
} lcdSymbol;

#define LCD_SYMBOL_GECKO_COM  1
#define LCD_SYMBOL_GECKO_SEG  0
#define LCD_SYMBOL_ANT_COM  0
#define LCD_SYMBOL_ANT_SEG  12
#define LCD_SYMBOL_PAD0_COM  3
#define LCD_SYMBOL_PAD0_SEG  19
#define LCD_SYMBOL_PAD1_COM  2
#define LCD_SYMBOL_PAD1_SEG  0
#define LCD_SYMBOL_EFM32_COM  0
#define LCD_SYMBOL_EFM32_SEG  8
#define LCD_SYMBOL_MINUS_COM  3
#define LCD_SYMBOL_MINUS_SEG  0
#define LCD_SYMBOL_COL3_COM  4
#define LCD_SYMBOL_COL3_SEG  0
#define LCD_SYMBOL_COL5_COM  0
#define LCD_SYMBOL_COL5_SEG  10
#define LCD_SYMBOL_COL10_COM  5
#define LCD_SYMBOL_COL10_SEG  19
#define LCD_SYMBOL_DEGC_COM  0
#define LCD_SYMBOL_DEGC_SEG  14
#define LCD_SYMBOL_DEGF_COM  0
#define LCD_SYMBOL_DEGF_SEG  15
#define LCD_SYMBOL_DP2_COM  7
#define LCD_SYMBOL_DP2_SEG  0
#define LCD_SYMBOL_DP3_COM  5
#define LCD_SYMBOL_DP3_SEG  0
#define LCD_SYMBOL_DP4_COM  6
#define LCD_SYMBOL_DP4_SEG  0
#define LCD_SYMBOL_DP5_COM  7
#define LCD_SYMBOL_DP5_SEG  9
#define LCD_SYMBOL_DP6_COM  7
#define LCD_SYMBOL_DP6_SEG  11
#define LCD_SYMBOL_DP10_COM  4
#define LCD_SYMBOL_DP10_SEG  19

#define LCD_STK3300             TRUE
#define LCD_DISPLAY_TYPE        8x20
#define LCD_BOOST_LEVEL         lcdVBoostLevel3

  /* LCD Controller Prescaler (divide LFACLK / 64) */
  /* LFACLK_LCDpre = 512 Hz */
  /* Set FDIV=0, means 512/1 = 512 Hz */
  /* With octaplex mode, 512/16 => 32 Hz Frame Rate */
#define LCD_CMU_CLK_PRE         cmuClkDiv_64
#define LCD_CMU_CLK_DIV         cmuClkDiv_1

#define LCD_INIT_DEF \
{ true,\
  lcdMuxOctaplex,\
  lcdBiasOneFourth,\
  lcdWaveLowPower,\
  lcdVLCDSelVDD,\
  lcdConConfVLCD }

#define LCD_NUMBER_OFF() \
do { \
  LCD_SegmentSetLow(0, 0x00078000, 0x00000000);\
  LCD_SegmentSetLow(1, 0x00078000, 0x00000000);\
  LCD_SegmentSetLow(2, 0x00078000, 0x00000000);\
  LCD_SegmentSetLow(3, 0x00078000, 0x00000000);\
  LCD_SegmentSetLow(4, 0x00078000, 0x00000000);\
  LCD_SegmentSetLow(5, 0x00078000, 0x00000000);\
  LCD_SegmentSetLow(6, 0x00078000, 0x00000000);\
  LCD_SegmentSetLow(7, 0x00078000, 0x00000000);\
} while (0)

#define LCD_ALPHA_NUMBER_OFF() \
do { \
  LCD_SegmentSetLow(7, 0x000075FE, 0x00000000);\
  LCD_SegmentSetLow(6, 0x00007FFE, 0x00000000);\
  LCD_SegmentSetLow(5, 0x00007FFE, 0x00000000);\
  LCD_SegmentSetLow(4, 0x00007FFE, 0x00000000);\
  LCD_SegmentSetLow(3, 0x00007FFE, 0x00000000);\
  LCD_SegmentSetLow(2, 0x00007FFE, 0x00000000);\
  LCD_SegmentSetLow(1, 0x00007FFE, 0x00000000);\
  LCD_SegmentSetLow(0, 0x00000A00, 0x00000000);\
} while(0)

#define LCD_ALL_SEGMENTS_OFF() \
do { \
  LCD_SegmentSetLow(0, 0xFFFFFFFF, 0x00000000);\
  LCD_SegmentSetLow(1, 0xFFFFFFFF, 0x00000000);\
  LCD_SegmentSetLow(2, 0xFFFFFFFF, 0x00000000);\
  LCD_SegmentSetLow(3, 0xFFFFFFFF, 0x00000000);\
  LCD_SegmentSetLow(4, 0xFFFFFFFF, 0x00000000);\
  LCD_SegmentSetLow(5, 0xFFFFFFFF, 0x00000000);\
  LCD_SegmentSetLow(6, 0xFFFFFFFF, 0x00000000);\
  LCD_SegmentSetLow(7, 0xFFFFFFFF, 0x00000000);\
} while(0)

#define LCD_ALL_SEGMENTS_ON() \
do { \
  LCD_SegmentSetLow(0, 0xFFFFFFFF, 0xFFFFFFFF);\
  LCD_SegmentSetLow(1, 0xFFFFFFFF, 0xFFFFFFFF);\
  LCD_SegmentSetLow(2, 0xFFFFFFFF, 0xFFFFFFFF);\
  LCD_SegmentSetLow(3, 0xFFFFFFFF, 0xFFFFFFFF);\
  LCD_SegmentSetLow(4, 0xFFFFFFFF, 0xFFFFFFFF);\
  LCD_SegmentSetLow(5, 0xFFFFFFFF, 0xFFFFFFFF);\
  LCD_SegmentSetLow(6, 0xFFFFFFFF, 0xFFFFFFFF);\
  LCD_SegmentSetLow(7, 0xFFFFFFFF, 0xFFFFFFFF);\
} while(0)

#define LCD_SEGMENTS_ENABLE() \
do { \
  LCD_SegmentRangeEnable(lcdSegmentAll, true);\
} while(0)

#define LCD_DISPLAY_ENABLE() \
do { \
  ;\
} while(0)

#define EFM_DISPLAY_DEF {\
  .Text        = {\
    { /* 1 */\
      .com[0] = 1, .com[1] = 1, .com[2] = 5, .com[3] = 7,\
      .bit[0] = 1, .bit[1] = 2, .bit[2] = 2, .bit[3] = 2,\
      .com[4] = 7, .com[5] = 3, .com[6] = 4, .com[7] = 2,\
      .bit[4] = 1, .bit[5] = 1, .bit[6] = 1, .bit[7] = 1,\
      .com[8] = 3, .com[9] = 2, .com[10] = 4, .com[11] = 6,\
      .bit[8] = 2, .bit[9] = 2, .bit[10] = 2, .bit[11] = 2,\
      .com[12] = 5, .com[13] = 6,\
      .bit[12] = 1, .bit[13] = 1\
    },\
    { /* 2 */\
      .com[0] = 1, .com[1] = 1, .com[2] = 5, .com[3] = 7,\
      .bit[0] = 3, .bit[1] = 4, .bit[2] = 4, .bit[3] = 4,\
      .com[4] = 7, .com[5] = 3, .com[6] = 4, .com[7] = 2,\
      .bit[4] = 3, .bit[5] = 3, .bit[6] = 3, .bit[7] = 3,\
      .com[8] = 3, .com[9] = 2, .com[10] = 4, .com[11] = 6,\
      .bit[8] = 4, .bit[9] = 4, .bit[10] = 4, .bit[11] = 4,\
      .com[12] = 5, .com[13] = 6,\
      .bit[12] = 3, .bit[13] = 3\
    },\
    { /* 3 */\
      .com[0] = 1, .com[1] = 1, .com[2] = 5, .com[3] = 7,\
      .bit[0] = 5, .bit[1] = 6, .bit[2] = 6, .bit[3] = 6,\
      .com[4] = 7, .com[5] = 3, .com[6] = 4, .com[7] = 2,\
      .bit[4] = 5, .bit[5] = 5, .bit[6] = 5, .bit[7] = 5,\
      .com[8] = 3, .com[9] = 2, .com[10] = 4, .com[11] = 6,\
      .bit[8] = 6, .bit[9] = 6, .bit[10] = 6, .bit[11] = 6,\
      .com[12] = 5, .com[13] = 6,\
      .bit[12] = 5, .bit[13] = 5\
    },\
    { /* 4 */\
      .com[0] = 1, .com[1] = 1, .com[2] = 5, .com[3] = 7,\
      .bit[0] = 7, .bit[1] = 8, .bit[2] = 8, .bit[3] = 8,\
      .com[4] = 7, .com[5] = 3, .com[6] = 4, .com[7] = 2,\
      .bit[4] = 7, .bit[5] = 7, .bit[6] = 7, .bit[7] = 7,\
      .com[8] = 3, .com[9] = 2, .com[10] = 4, .com[11] = 6,\
      .bit[8] = 8, .bit[9] = 8, .bit[10] = 8, .bit[11] = 8,\
      .com[12] = 5, .com[13] = 6,\
      .bit[12] = 7, .bit[13] = 7\
    },\
    { /* 5 */\
      .com[0] = 0, .com[1] = 1, .com[2] = 5, .com[3] = 7,\
      .bit[0] = 9, .bit[1] = 10, .bit[2] = 10, .bit[3] = 10,\
      .com[4] = 6, .com[5] = 2, .com[6] = 3, .com[7] = 1,\
      .bit[4] = 9, .bit[5] = 9, .bit[6] = 9, .bit[7] = 9,\
      .com[8] = 3, .com[9] = 2, .com[10] = 4, .com[11] = 6,\
      .bit[8] = 10, .bit[9] = 10, .bit[10] = 10, .bit[11] = 10,\
      .com[12] = 4, .com[13] = 5,\
      .bit[12] = 9, .bit[13] = 9\
    },\
    { /* 6 */\
      .com[0] = 0, .com[1] = 1, .com[2] = 5, .com[3] = 7,\
      .bit[0] = 11, .bit[1] = 12, .bit[2] = 12, .bit[3] = 12,\
      .com[4] = 6, .com[5] = 2, .com[6] = 3, .com[7] = 1,\
      .bit[4] = 11, .bit[5] = 11, .bit[6] = 11, .bit[7] = 11,\
      .com[8] = 3, .com[9] = 2, .com[10] = 4, .com[11] = 6,\
      .bit[8] = 12, .bit[9] = 12, .bit[10] = 12, .bit[11] = 12,\
      .com[12] = 4, .com[13] = 5,\
      .bit[12] = 11, .bit[13] = 11\
    },\
    { /* 7 */\
      .com[0] = 1, .com[1] = 1, .com[2] = 5, .com[3] = 7,\
      .bit[0] = 13, .bit[1] = 14, .bit[2] = 14, .bit[3] = 14,\
      .com[4] = 7, .com[5] = 3, .com[6] = 4, .com[7] = 2,\
      .bit[4] = 13, .bit[5] = 13, .bit[6] = 13, .bit[7] = 13,\
      .com[8] = 3, .com[9] = 2, .com[10] = 4, .com[11] = 6,\
      .bit[8] = 14, .bit[9] = 14, .bit[10] = 14, .bit[11] = 14,\
      .com[12] = 5, .com[13] = 6,\
      .bit[12] = 13, .bit[13] = 13\
    },\
  },\
  .Number      = {\
    {\
      .com[0] = 7, .com[1] = 5, .com[2] = 2, .com[3] = 1,\
      .bit[0] = 15, .bit[1] = 15, .bit[2] = 15, .bit[3] = 15,\
      .com[4] = 3, .com[5] = 6, .com[6] = 4,\
      .bit[4] = 15, .bit[5] = 15, .bit[6] = 15,\
    },\
    {\
      .com[0] = 7, .com[1] = 5, .com[2] = 2, .com[3] = 1,\
      .bit[0] = 16, .bit[1] = 16, .bit[2] = 16, .bit[3] = 16,\
      .com[4] = 3, .com[5] = 6, .com[6] = 4,\
      .bit[4] = 16, .bit[5] = 16, .bit[6] = 16,\
    },\
    {\
      .com[0] = 7, .com[1] = 5, .com[2] = 2, .com[3] = 1,\
      .bit[0] = 17, .bit[1] = 17, .bit[2] = 17, .bit[3] = 17,\
      .com[4] = 3, .com[5] = 6, .com[6] = 4,\
      .bit[4] = 17, .bit[5] = 17, .bit[6] = 17,\
    },\
    {\
      .com[0] = 7, .com[1] = 5, .com[2] = 2, .com[3] = 1,\
      .bit[0] = 18, .bit[1] = 18, .bit[2] = 18, .bit[3] = 18,\
      .com[4] = 3, .com[5] = 6, .com[6] = 4,\
      .bit[4] = 18, .bit[5] = 18, .bit[6] = 18,\
    },\
  },\
  .EMode       = {\
    .com[0] = 0, .bit[0] = 19,\
    .com[1] = 1, .bit[1] = 19,\
    .com[2] = 7, .bit[2] = 19,\
    .com[3] = 2, .bit[3] = 19,\
    .com[4] = 6, .bit[4] = 19,\
  },\
  .ARing       = {\
    .com[0] = 0, .bit[0] = 7,\
    .com[1] = 0, .bit[1] = 6,\
    .com[2] = 0, .bit[2] = 5,\
    .com[3] = 0, .bit[3] = 4,\
    .com[4] = 0, .bit[4] = 3,\
    .com[5] = 0, .bit[5] = 2,\
    .com[6] = 0, .bit[6] = 1,\
    .com[7] = 0, .bit[7] = 0,\
  },\
  .Battery     = {\
    .com[0] = 0, .bit[0] = 13,\
    .com[1] = 0, .bit[1] = 17,\
    .com[2] = 0, .bit[2] = 16,\
    .com[3] = 0, .bit[3] = 18,\
  }\
}

static const PinName outPins[] = {
        /* SEG28..39 */
		PA7,	//LCD_SEG35
		PA8,	//LCD_SEG36
		PA9,	//LCD_SEG37
		PA10,	//LCD_SEG38
		PA11,	//LCD_SEG39
		PB0,	//LCD_SEG32
		PB1,	//LCD_SEG33
		PB2,	//LCD_SEG34
		PD9,	//LCD_SEG28
		PD10,	//LCD_SEG29
		PD11,	//LCD_SEG30
		PD12,	//LCD_SEG31
        /* SEG12..19 */
		PA0,	//LCD_SEG13
		PA1,	//LCD_SEG14
		PA2,	//LCD_SEG15
		PA3,	//LCD_SEG16
		PA4,	//LCD_SEG17
		PA5,	//LCD_SEG18
		PA6,	//LCD_SEG19
		PA15,	//LCD_SEG12
        /* COM4..7 */
		PB3,	//LCD_COM4
		PB4,	//LCD_COM5
		PB5,	//LCD_COM6
		PB6,	//LCD_COM7
        /* COM0..3 */
		PE4,	//LCD_COM0
		PE5,	//LCD_COM1
		PE6,	//LCD_COM2
		PE7		//LCD_COM3
};

#ifdef __cplusplus
}
#endif

#endif
