#ifndef __RADIO_EVENT_H__
#define __RADIO_EVENT_H__

#include "dot_util.h"
#include "mDotEvent.h"
#include "Fota.h"
#include <string.h>

extern bool rejoin;
extern uint16_t rain_total;
extern float uplinkInterval;
extern uint8_t downlink_msg;

class RadioEvent : public mDotEvent
{

public:
    RadioEvent() {}

    virtual ~RadioEvent() {}

    virtual void PacketRx(uint8_t port, uint8_t *payload, uint16_t size, int16_t rssi, int16_t snr, lora::DownlinkControl ctrl, uint8_t slot, uint8_t retries, uint32_t address, bool dupRx) {
        mDotEvent::PacketRx(port, payload, size, rssi, snr, ctrl, slot, retries, address, dupRx);
        
#if ACTIVE_EXAMPLE == FOTA_EXAMPLE
        if(port == 200 || port == 201 || port == 202) {
            Fota::getInstance()->processCmd(payload, port, size);
        }
#endif
    }

    /*!
     * MAC layer event callback prototype.
     *
     * \param [IN] flags Bit field indicating the MAC events occurred
     * \param [IN] info  Details about MAC events occurred
     */
    virtual void MacEvent(LoRaMacEventFlags* flags, LoRaMacEventInfo* info) {

        if (mts::MTSLog::getLogLevel() == mts::MTSLog::TRACE_LEVEL) {
            std::string msg = "OK";
            switch (info->Status) {
                case LORAMAC_EVENT_INFO_STATUS_ERROR:
                    msg = "ERROR";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_TX_TIMEOUT:
                    msg = "TX_TIMEOUT";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_RX_TIMEOUT:
                    msg = "RX_TIMEOUT";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_RX_ERROR:
                    msg = "RX_ERROR";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_JOIN_FAIL:
                    msg = "JOIN_FAIL";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_DOWNLINK_FAIL:
                    msg = "DOWNLINK_FAIL";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_ADDRESS_FAIL:
                    msg = "ADDRESS_FAIL";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_MIC_FAIL:
                    msg = "MIC_FAIL";
                    break;
                default:
                    break;
            }
            logTrace("Event: %s", msg.c_str());

            logTrace("Flags Tx: %d Rx: %d RxData: %d RxSlot: %d LinkCheck: %d JoinAccept: %d",
                     flags->Bits.Tx, flags->Bits.Rx, flags->Bits.RxData, flags->Bits.RxSlot, flags->Bits.LinkCheck, flags->Bits.JoinAccept);
            logTrace("Info: Status: %d ACK: %d Retries: %d TxDR: %d RxPort: %d RxSize: %d RSSI: %d SNR: %d Energy: %d Margin: %d Gateways: %d",
                     info->Status, info->TxAckReceived, info->TxNbRetries, info->TxDatarate, info->RxPort, info->RxBufferSize,
                     info->RxRssi, info->RxSnr, info->Energy, info->DemodMargin, info->NbGateways);
        }

        if (flags->Bits.Rx) {

            logDebug("Rx %d bytes", info->RxBufferSize);
            if (info->RxBufferSize > 0) {
//#if ACTIVE_EXAMPLE != FOTA_EXAMPLE
                // print RX data as string and hexadecimal
                std::string rx((const char*)info->RxBuffer, info->RxBufferSize);
                //printf("Rx data: %s [%s]\r\n", rx.c_str(), mts::Text::bin2hexString(info->RxBuffer, info->RxBufferSize).c_str());
                
/// - SECTION FOR DOWNLINK HANDLING - ////////////////////////////////////////////////////////////////////////////////////////////////////
                std::string rxData = mts::Text::bin2hexString(info->RxBuffer, info->RxBufferSize).c_str();
                logInfo("Rx data: [%s]\r", mts::Text::bin2hexString(info->RxBuffer, info->RxBufferSize).c_str());
                
                if(rxData.compare("01") == 0){
                    logInfo("Command received: [01]");
                    logInfo("Soft reset of the system");
                    dot->resetCpu();
                }
                else if(rxData.compare("02") == 0){
                    logInfo("Command received: [02]");
                    logInfo("Setting rain_total to 0");
                    rain_total = 0;
                    downlink_msg = 0x02;
                }
                else if(rxData.compare("03") == 0){
                    logInfo("Command received: [03]");
                    logInfo("Setting uplinkInterval to 15mins");
                    uplinkInterval = 15;
                    downlink_msg = 0x03;
                }
                else if(rxData.compare("04") == 0){
                    logInfo("Command received: [04]");
                    logInfo("Setting uplinkInterval to 30mins");
                    uplinkInterval = 30;
                    downlink_msg = 0x04;
                }
                else if(rxData.compare("05") == 0){
                    logInfo("Command received: [05]");
                    logInfo("Setting uplinkInterval to 60mins");
                    uplinkInterval = 60;
                    downlink_msg = 0x05;
                }
                else if(rxData.compare("06") == 0){
                    logInfo("Command received: [06]");
                    logInfo("Setting uplinkInterval to 1min (for debugging)");
                    uplinkInterval = 1;
                    downlink_msg = 0x06;
                }
                else if(rxData.compare("07") == 0){
                    logInfo("Command received: [07]");
                    logInfo("Setting ACK to: 0 (off)");
                    if (dot->setAck(0) != mDot::MDOT_OK) {
                        logError("failed to set acks to %u", 0);
                    }
                }
                else if(rxData.compare("08") == 0){
                    logInfo("Command received: [08]");
                    logInfo("Setting ACK to: 1");
                    if (dot->setAck(1) != mDot::MDOT_OK) {
                        logError("failed to set acks to %u", 1);
                    }
                }
                else if(rxData.compare("09") == 0){
                    logInfo("Command received: [09]");
                    logInfo("Setting ACK to: 3");
                    if (dot->setAck(3) != mDot::MDOT_OK) {
                        logError("failed to set acks to %u", 3);
                    }
                }
                else if(rxData.compare("0a") == 0){
                    logInfo("Command received: [0a]");
                    logInfo("Setting ACK to: 5");
                    if (dot->setAck(5) != mDot::MDOT_OK) {
                        logError("failed to set acks to %u", 5);
                    }
                }
                else if(rxData.compare("0b") == 0){
                    logInfo("Command received: [0b]");
                    logInfo("Setting ACK to: 8 (max)");
                    if (dot->setAck(8) != mDot::MDOT_OK) {
                        logError("failed to set acks to %u", 8);
                    }
                }
                else{
                    logInfo("Unknown downlink command received");
                    downlink_msg = 0xFF;
                }
                
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//#endif
            }
        }
    }

#if ACTIVE_EXAMPLE == FOTA_EXAMPLE
    virtual void ServerTime(uint32_t seconds, uint8_t sub_seconds) {
        mDotEvent::ServerTime(seconds, sub_seconds);

        Fota::getInstance()->setClockOffset(seconds);
    }
#endif
};

#endif

