#include "mbed.h"
#include "Pulse1.h"

//------------------------------------
// Hyperterminal configuration
// 115200 bauds, 8-bit data, no parity
// pwm범위 : 920 ~ 2080, 중간값은 1500
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX, 115200);

PulseInOut valueOfLeftAndRight(A0); //채널1, futaba기준 좌우방향(오른쪽 조이스틱)
PulseInOut valueOfFrontAndRear(A1); //채널2, futaba기준 상하방향(오른쪽 조이스틱)
PulseInOut valueOfScrewSpeed(A2);   //채널3, futaba기준 상하방향, 회수스크류(왼쪽 조이스틱)

int main()
{
    
    while(1) {
        pc.printf("-----------------------------------\n");
        pc.printf("Left and Right PWM : pw = %d \n",valueOfLeftAndRight.read_high_us(30000));   //마이크로초 단위로 받아옴
        pc.printf("Front and Rear PWM : pw = %d \n",valueOfFrontAndRear.read_high_us(30000));
        pc.printf("Screw PWM : pw = %d \n",valueOfScrewSpeed.read_high_us(30000));


        wait(0.5);
    }
}
