#include "mbed.h"
#include "Servo.h"
#include "Map.h"
#include "Pulse1.h"

// 후진 불가능한 BLDC 사용 


PwmOut led_left(LED1); //확인용 LED1
PwmOut led_right(LED2); //확인용 LED2

Servo bldc_left(PB_8); // 왼쪽 BLDC D12
Servo bldc_right(PB_9); // 오른쪽 BLDC PC_7

PulseInOut Channel1(A0); //채널1, futaba기준 좌우방향(오른쪽 조이스틱)
PulseInOut Channel2(A1); //채널2, futaba기준 상하방향(오른쪽 조이스틱)
PulseInOut Channel3(A2); //채널3, futaba기준 상하방향(왼쪽 조이스틱)

int main() {
    bldc_left.write(0); // BLDC 초기 설정
    bldc_right.write(0);
    
    led_left = 1; // 확인을 위한 LED
    led_right=1; // 확인을 위한 LED
    wait(0.5);
    
    bldc_left.write(1);
    bldc_right.write(1);
    
    led_left =0; // 확인을 위한 LED
    led_right=0; // 확인을 위한 LED
    wait(2);
    
    bldc_left.write(0); // BLDC 초기 설정
    bldc_right.write(0); // BLDC 초기 설정
    wait(2);
    
    float raw1,raw2,raw3;
    float mod1,mod2,mod3,mod4,mod5;
    printf("\nBLDC Setup & end\n");
    
    while (1) {
        
        
        raw1 = Channel1.read_high_us(30000);
        raw2 = Channel2.read_high_us(30000);
        raw3 = Channel3.read_high_us(30000);
        
        
        //printf("raw1=%.0f mV\t", raw1);
        mod1 =  map(raw2, 1450, 1000, 0, 60); // 후진 //PWM 150을 변환
        mod2 =  map(raw2, 1550, 2000, 0, 90); // 전진 //PWM 150을 변환
        
        
        
        //printf("raw2=%.0f mV\t", raw2);
        mod3 =  map(raw1, 1450, 1000, 0, 60); // 좌회전 //PWM 150을 변환
        mod4 =  map(raw1, 1550, 2000, 0, 60); // 우회전 //PWM 150을 변환
        
        //printf("raw3=%.0f mV\t", raw3);
        mod5 =  map(raw3, 920, 2080, 0, 100);
        
        printf("mod1=%.0f mV\t", mod1);
        printf("mod2=%.0f mV\t", mod2);
        printf("mod3=%.0f mV\t", mod3);
        printf("mod4=%.0f mV\t", mod4);
        printf("mod5=%.0f mV\t", mod5);
        
        mod1 = mod1/100;
        mod2 = mod2/100;
        mod3 = mod3/100;
        mod4 = mod4/100;
        mod5 = mod5/100;
        
        printf("measure1 = %f mV\t", mod1);
        printf("measure2 = %f mV\t", mod2);
        printf("measure3 = %f mV\t", mod3);
        printf("measure4 = %f mV\t", mod4);
        printf("measure5 = %f mV\n", mod5);
        
        
        if(mod3 > 0.01) { // 2
            mod4 = 0;
            }
            
        if(mod4 > 0.01) { // 2
            mod3 = 0;
            }
            
        
        float bldc_l, bldc_r; // bldc 왼쪽 오른쪽 선언
        bldc_l = mod2 - mod3 + mod4;
        bldc_r = mod2 + mod3 - mod4;
        
        if(bldc_l >= 0.6) { // PWM 150을 변환
            bldc_l = 0.6;
            }
        if(bldc_l <= 0.03) { // PWM 20을 변환
            bldc_l = 0;
            }
            
        if(bldc_r >= 0.6) { // PWM 150을 변환
            bldc_r = 0.6;
            }
        if(bldc_r <= 0.03) { // PWM 20을 변환
            bldc_r = 0;
            }
        
        bldc_left.write(bldc_l);
        bldc_right.write(bldc_r);
        

        led_left.write(bldc_l);
        led_right.write(bldc_r);
        }
}

