//Timer for 2 player snake game
//2 line LCD implemented using TextLCD library

#include "mbed.h"
#include "TextLCD.h"

int GameRunning;                //True if game is running
int c;                          //count variable
Timer timer;                    //Use mbed's built in timer function
float StartTime, NowTime;       //Floats for the timer reading at gamestart and currently

InterruptIn btnStart(PTA4);       //Temporarily use switch to start - will be WiFi command
InterruptIn btnStop(PTA5);        //Temporarily use switch to stop - will be WiFi command


void timerStart() {
    timer.start(); 
    StartTime = timer.read_us();
    GameRunning = 1;
}

void timerStop() {
    timer.stop();
    NowTime = timer.read_us();   
    GameRunning = 0;
}

   
TextLCD lcd(PTE30, PTE29, PTE23, PTE22, PTE21, PTE20); // rs, e, d4-d7

int main()
{
    btnStart.rise(&timerStart);
    btnStop.rise(&timerStop);
    //timer.start(); 
    //StartTime = timer.read_us();
    
    while(1) 
    {

        NowTime = timer.read_us();
        lcd.printf("Time: %4.3f \n\n", (NowTime-StartTime)/1000000);
        wait(0.05);

    }
}
