/**
    Food Controller
    main.cpp
    Board ID:   1
    Purpose:    This function runs on a FRDM KL25Z. It uses the accelerometer to measure the tilt of the board.
                It outputs a 2 bit number that describes the direction. The board is also fitted with four LEDS
                oriented in the following configuration: o8o to provide feedback to the user. This board also 
                makes use of the touch sensor input to set a variable speed for the food, formerly indicated by 
                RGB LED (functionality removed due to power issues)
    @author Daniel Lock
    @author Jamie Gnodde
    @version
*/

#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
Serial pc(USBTX, USBRX); // tx, rx  used for printing to the PC screen during debugging

TSISensor tsi;                                      //Setup touch sensor
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);    //Setup accelerometer
DigitalOut lefthigh(PTC5);                          //LED for left
DigitalOut leftlow(PTA4);
DigitalOut righthigh(PTC11);                         //LED for right
DigitalOut rightlow(PTC9);
DigitalOut forwardhigh(PTC6);                       //LED for forward
DigitalOut forwardlow(PTC10);
DigitalOut backwardhigh(PTA5);                      //LED for backward
DigitalOut backwardlow(PTC8);

RawSerial dev(PTE0,PTE1);  // for KL25Z... asuming one can't use the PTA1 version which is the stdio
DigitalOut rst(PTD1); // single digital pin to drive the esp8266 reset line

int Direction;                                      //2 bit number to describe direction 0 forward assigned CW
int PrevDirection;                                  //2 bit number to describe last direction sent ot server
int Velocity;                                       //2 bit number to vary velocity in game
int PrevVelocity;                                   //2 bit number to describe last velocity sent ot server

bool right;                                         //Right or left? right = 1
bool forward;                                       //Forward or Backward? forward = 1

// subroutine to run anytime a serial interrupt arrives from the device
// this basically passes everything thatthe device produces on to the pc terminal screen
void dev_recv()
{
    //led1 = !led1;
    while(dev.readable()) {
        pc.putc(dev.getc());
        //wait_us(1);
    }
}
// subroutine to service the serial interrupt on the pc connection
// this is a bit more complex - it takes what the use sends on the pc and copies it on to the device 
// the esp should echo these straight back to the the pc if all is well
// this also detects the end of command character which is ascii 13 (0x0d) adn adds a linefeed after it =asscii 10 (0x0a)
void pc_recv()
{
    char c;
    //led4 = !led4;
    while(pc.readable()) {
        c=pc.getc();
        dev.putc(c);
        pc.putc(c); // echo back
        if(c==13) {dev.putc(10); // send the linefeed to complement the carriage return generated by return key on the pc
        pc.putc(10);
            }
    }
}

void setupWiFi()
{
    dev.printf("AT+RST\r\n");                       //Reset WiFi
    pc.printf("RESET\r\n");
    
    wait(2);
    dev.printf("AT+CWMODE=1\r\n");                  //Set mode to client
    
    wait(2);
    dev.printf("AT+CWJAP=\"CWMWIFI\",\"CWM2016TT\"\r\n");       //Login to the WiFi
    
    wait(7);
    dev.printf("AT+CIFSR\r\n");                     //Find IP and MAC address - not necessary?
    
    wait(5);
    dev.printf("AT+CIPMUX=1\r\n");                  //Allow multiple connections
    
    wait(2);
    dev.printf("AT+CIPSTART=0,\"TCP\",\"192.168.1.6\",5050\r\n");       //Open connection with the server
    
}


int main()
{
    //Initialise WiFi stuff
    rst=0;
    wait(1);
    rst=1; // send the esp8266 reset
    wait(1);
    pc.printf("ok off we go....\n\r");
    
    pc.baud(115200); // NB maybe this should go before this
    dev.baud(115200);

    pc.attach(&pc_recv, Serial::RxIrq); // attach the two interrupt services
    dev.attach(&dev_recv, Serial::RxIrq);
    
    PrevDirection = 4;                            //Initialise PrevDirection with a value that will mean it will always pass throught he if at the end
    PrevVelocity = 4;                             //Initialise PrevVelocity with a value that will mean it will always pass throught he if at the end
    setupWiFi();                                  //Run the WiFi setup
    while (1) 
    {
         
        float accX=acc.getAccX();                   //Measure acceleration in X direction
        float accY=acc.getAccY();                   //Measure acceleration in Y direction

         if (tsi.readDistance() != 0)               //Only execute if the touch sensor is being pressed
        {          
            if (tsi.readDistance() <= 13)           //Length of touch sensor divided into three distinct zones, this defines top zone
            {
                Velocity = 3;                       //Top zone -> highest velocity (varies 1-3)
                /*rled = 0;                           //Use the RGB LED as an indicator for which speed is selected
                bled = 1;
                gled = 1;*/ //removed due to power issues
            }
            if (tsi.readDistance() > 13 && tsi.readDistance() < 26)         //Middle zone of touch sensor
            {
                Velocity = 2;                       //Middle zone -> middle velocity
               /*rled = 1;                           //Use the RGB LED as an indicator for which speed is selected
                bled = 0;
                gled = 1;  */            
            }
            if (tsi.readDistance() >= 26)
            {
                Velocity = 1;                       //Bottom zone -> lowest velocity
               /* rled = 1;                           //Use the RGB LED as an indicator for which speed is selected
                bled = 1;
                gled = 0;*/
            }
                             
            //printf("x=%d\r\n",Velocity);            //Print the velocity to the serial for debugging
           
            wait(0.2);                              //May be left over from debugging?

        }//endif touch sensor 
     
        //Establish whether the board is tilted left or right         
        if (accX > 0.1) 
        {
            right = false;
            //printf("left \r\n");
        }//endif

        if (accX < -0.1) 
        {
            right = true;
            //printf("right \r\n");
        }//endif
        
        wait(0.1);                                  //May be left over from debugging?

        //Establish whether the board is tilted front or back
        if (accY > 0.1) 
        {
            forward = false;
            //printf("back \r\n");
        }//endif

        if (accY < -0.1) 
        {
            forward = true;            
            //printf("for \r\n");
        }//endif
        
        wait(0.1);                                  //May be left over from debugging?
        
        //Establish the main axis of tilting so that the control outputs one direction        
        if(abs(accY) > abs(accX))
        {
            if(forward == true)
            {
                Direction = 0;                  //Direction variable is a two bit number 0-3 0 is forward
                
                lefthigh = 0;                   //Light up the forward LED, make sure all others are off
                leftlow = 0;
                righthigh = 0;
                rightlow = 0;
                forwardhigh = 1;
                forwardlow = 0;
                backwardhigh = 0;
                backwardlow = 0;                
            
            }//endif
            else
            {
                Direction = 2;                  //Direction variable is a two bit number 0-3 2 is backward
                
                lefthigh = 0;                   //Light up the backward LED, make sure all others are off
                leftlow = 0;
                righthigh = 0;
                rightlow = 0;
                forwardhigh = 0;
                forwardlow = 0;
                backwardhigh = 1;
                backwardlow = 0;
                   
            }//endelse
        }//endif
        else
        {
            if(right == true)
            {
                Direction = 1;                  //Direction variable is a two bit number 0-3 1 is right
                
                lefthigh = 0;                   //Light up the right LED, make sure all others are off
                leftlow = 0;
                righthigh = 1;
                rightlow = 0;
                forwardhigh = 0;
                forwardlow = 0;
                backwardhigh = 0;
                backwardlow = 0;
             
            }//endif
            else
            {
                Direction = 3;                  //Direction variable is a two bit number 0-3 3 is left
                
                lefthigh = 1;                   //Light up the left LED, make sure all others are off
                leftlow = 0;
                righthigh = 0;
                rightlow = 0;
                forwardhigh = 0;
                forwardlow = 0;
                backwardhigh = 0;
                backwardlow = 0;                
                    
            }//endelse
        }//endelse
        
        //pc.printf("Direction = %d \r\n", Direction);           //Print the direction variable to screen for debugging
        
        //Only send data to the server if the direction has changed
     if(Direction != PrevDirection || Velocity != PrevVelocity)
        {
            //Send Direction and Velocity to server
            
            dev.printf("AT+CIPSEND=0,11\r\n");
            wait(0.1);
            
            //pc.printf("1dir%dvel%d\r\n",Direction,Velocity);              //Identifier,Direction Tag,Direction Value,Velocity Tag,Velocity Value
            dev.printf("1dir%dvel%d\r\n",Direction,Velocity);              //Identifier,Direction Tag,Direction Value,Velocity Tag,Velocity Value
            
            PrevDirection = Direction;                           //Store Direction just sent as last sent direction
            PrevVelocity = Velocity;                             //Store Velocity just sent as last sent velocity   
        }
       
    }//endwhile
}//endmain
