#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
Serial pc(USBTX, USBRX); // tx, rx

PwmOut gled(LED_GREEN);                             //Indicator for touch sensor Output
TSISensor tsi;                                      //Setup touch sensor
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);    //Setup accelerometer
DigitalOut lefthigh(PTC11);                         //Test LED for left
DigitalOut leftlow(PTC9);
DigitalOut righthigh(PTC5);                         //Test LED for right
DigitalOut rightlow(PTA4);
DigitalOut forwardhigh(PTC16);                      //Test LED for forward
DigitalOut forwardlow(PTD0);
DigitalOut backwardhigh(PTA17);                     //Test LED for backward
DigitalOut backwardlow(PTD1);

float accX=acc.getAccX();                           //Measure acceleration in X direction
float accY=acc.getAccY();                           //Measure acceleration in Y direction

int Direction;                                      //2 bit number to describe direction 0 forward assigned CW
int Velocity;                                       //2 bit number to vary velocity in game

bool right;                                         //Right or left? right = 1
bool forward;                                       //Forward or Backward? forward = 1

int main()
{
    while (1) 
    {
         
        float accX=acc.getAccX();                           //Measure acceleration in X direction
        float accY=acc.getAccY();                           //Measure acceleration in Y direction

         if (tsi.readDistance() != 0) 
        {
//          gled = 1.0 - tsi.readPercentage();          
            if (tsi.readDistance() <= 13)
            {
                Velocity = 3;
            }
            if (tsi.readDistance() > 13 && tsi.readDistance() < 26)
            {
                Velocity = 2;
            }
            if (tsi.readDistance() >= 26)
            {
                Velocity = 1;
            }
                                   
            printf("x=%d\r\n",Velocity);
            wait(0.2);


        }//endif touch sensor 


        if((accX <= 0.1f) && (accX >= -0.1f)) 
        {
            if (right == false) 
            {
                righthigh = 1;
                rightlow = 0;
            } //endif
            else 
            {
                lefthigh = 1;
                leftlow = 0;
            }//endelse
        }//endif
        
        if (accX > 0.1) 
        {
            lefthigh = 0;
            leftlow = 0;
            righthigh = 1;
            rightlow = 0;
            forwardhigh = 0;
            forwardlow = 0;
            backwardhigh = 0;
            backwardlow = 0;
            right = false;
            printf("left \r\n");
        }//endif

        if (accX < -0.1) 
        {
            lefthigh = 1;
            leftlow = 0;
            righthigh = 0;
            rightlow = 0;
            forwardhigh = 0;
            forwardlow = 0;
            backwardhigh = 0;
            backwardlow = 0;
            right = true;
            printf("right \r\n");
        }//endif
        wait(0.1);    

        if((accY <= 0.1) && (accY >= -0.1)) 
        {
            if (forward == false) 
            {
                forwardhigh = 1;
                forwardlow = 0;
            }//endif 
            else
            {
                backwardhigh = 1;
                backwardlow = 0;
            }//endelse
        }//endif

        if (accY > 0.1) 
        {
            lefthigh = 0;
            leftlow = 0;
            righthigh = 0;
            rightlow = 0;
            forwardhigh = 1;
            forwardlow = 0;
            backwardhigh = 0;
            backwardlow = 0;
            forward = false;
            printf("back \r\n");
        }//endif

        if (accY < -0.1) 
        {
            lefthigh = 0;
            leftlow = 0;
            righthigh = 0;
            rightlow = 0;
            forwardhigh = 0;
            forwardlow = 0;
            backwardhigh = 1;
            backwardlow = 0;
            forward = true;            
            printf("for \r\n");
        }//endif
        
        wait(0.1);
        
        if(abs(accY) > abs(accX))
        {
            if(forward == true)
            {
                Direction = 0;
            }//endif
            else
            {
                Direction = 2;   
            }//endelse
        }//endif
        else
        {
            if(right == true)
            {
                Direction = 1;   
            }//endif
            else
            {
                Direction = 3;    
            }//endelse
        }//endelse
        
        printf("Direction = %d \r\n", Direction);
        
    }//endwhile
}//endmain
