#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
Serial pc(USBTX, USBRX); // tx, rx

PwmOut gled(LED_GREEN);                             //Indicator for touch sensor Output
TSISensor tsi;                                      //Setup touch sensor
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);    //Setup accelerometer
DigitalOut lefthigh(PTC11);                         //Test LED for left
DigitalOut leftlow(PTC9);
DigitalOut righthigh(PTC5);                         //Test LED for right
DigitalOut rightlow(PTA4);
DigitalOut forwardhigh(PTC16);                      //Test LED for forward
DigitalOut forwardlow(PTD0);
DigitalOut backwardhigh(PTA17);                     //Test LED for backward
DigitalOut backwardlow(PTD1);

float accX=acc.getAccX();                           //Measure acceleration in X direction
float accY=acc.getAccY();                           //Measure acceleration in Y direction

int Direction;                                      //2 bit number to describe direction 0 forward assigned CW
int Velocity;                                       //2 bit number to vary velocity in game

bool right;                                         //Right or left? right = 1
bool forward;                                       //Forward or Backward? forward = 1

int main()
{
    while (1) 
    {
        if (tsi.readPercentage() != 0) 
        {
          gled = 1.0 - tsi.readPercentage();          
        }//endif touch sensor

        if((accX <= 0.1f) && (accX >= -0.1f)) 
        {
            if (right == true) 
            {
                righthigh = 1;
                rightlow = 0;
            } //endif
            else 
            {
                lefthigh = 1;
                leftlow = 0;
            }//endelse
        }//endif

        if (accX > 0.1) 
        {
            lefthigh = 0;
            leftlow = 0;
            righthigh = 1;
            rightlow = 0;
            forwardhigh = 0;
            forwardlow = 0;
            backwardhigh = 0;
            backwardlow = 0;
            right = true;
        }//endif

        if (accX < -0.1) 
        {
            lefthigh = 1;
            leftlow = 0;
            righthigh = 0;
            rightlow = 0;
            forwardhigh = 0;
            forwardlow = 0;
            backwardhigh = 0;
            backwardlow = 0;
            right = false;
        }//endif
        wait(0.1);

        if((acc.getAccY() <= 0.1) && (acc.getAccY() >= -0.1)) 
        {
            if (forward == true) 
            {
                forwardhigh = 1;
                forwardlow = 0;
            }//endif 
            else
            {
                backwardhigh = 1;
                backwardlow = 0;
            }//endelse
        }//endif

        if (acc.getAccY() > 0.1) 
        {
            lefthigh = 0;
            leftlow = 0;
            righthigh = 0;
            rightlow = 0;
            forwardhigh = 1;
            forwardlow = 0;
            backwardhigh = 0;
            backwardlow = 0;
            forward = true;
        }//endif

        if (acc.getAccY() < -0.1) 
        {
            lefthigh = 0;
            leftlow = 0;
            righthigh = 0;
            rightlow = 0;
            forwardhigh = 0;
            forwardlow = 0;
            backwardhigh = 1;
            backwardlow = 0;
            forward = false;
        }//endif
        wait(0.1);
    }//endwhile
}//endmain
