// STM32 - ESCON module test program (BLDC motor)
// Created by Yoshimichi Oka 2020.3.4
// Modified by Yoshimichi Oka 2020.7.27
// Department of Robotics, Ritsumeikan University, Japan
#include "mbed.h"

DigitalOut myled(PF_1);     // LED for communication check
DigitalOut motorDir1(PA_9);  // D1 モータのオンオフ（'HIGH'でオン．ESCON Studioで変更可能）
DigitalOut motorDir2(PA_10); // D0 回転方向（向きはESCON Studioで設定）
AnalogOut Vd1(PA_6);         // A3 Desired value for the velocity control
AnalogOut Vd2(PA_5);         // A5 Desired value for the current control
//AnalogIn potensio2(PA_1); Analog Signal from ESCON (current or velocity, set by ESCON)
//AnalogIn potensio2(PA_3); Analog Signal from ESCON (current or velocity, set by ESCON)

//今回は目標値をA0ピンに接続したポテンショメータから読み取り制御する
AnalogIn potensio1(PA_0);    // A0 Potentiometer 1


void motorForward(void);
void motorStop(void);
void motorReverse(void);
float outValue;

/*
ESCONドライバが0.0~3.3Vのアナログ電圧値で-10400.0~10400.0[rpm]の回転数データを送ってくるので，
データを格納する変数には念のためfloat(4byte)ではなくdouble(8byte)を使用（doubleはfloatのおよそ倍の精度）
受け取ったデータは0-3.3Vを0-1に変換して表示しているので，3.3をかけた後に目的に応じてさらに回転数などの値に変換する
*/

Serial pc(USBTX, USBRX); // tx, rx tera terminal等を使用してPCにA0ピンのセンサアナログ値を表示させる

//BLDCモータの動作
void motorForward(void);
void motorStop(void);
void motorReverse(void);

int main() {

    while(1) {
        double pot = potensio1.read();  //0-1(0V~3.3V)
        outValue = 0.5;//pot;
        //pc.printf("%f, %f\r\n", pot, outValue);  //PC表示（確認用）
        
        if (outValue > 0.5){
            motorForward();
            }
            else{
                motorReverse();
                }
        
        Vd2 = outValue; //目標値としてESCONへ出力
        //Vd2 = outValue;
            myled = 1; // LED is ON
            wait (0.01);


    }
}

void motorForward() {
    motorStop();
    motorDir1 = 1;
    motorDir2 = 0;
}
 
void motorReverse() {
    motorStop();
    motorDir1 = 1;
    motorDir2 = 1;
}
 
void motorStop() {
    motorDir1 = 0;
}