#include "mbed.h"

Serial serial(D1,D0);
DigitalOut led1(LED1);
Timer       timer;

// main() runs in its own thread in the OS
int main() {
    char    buffer[256];
    
    serial.baud(9600);
    timer.start();
 
    printf("Blinky example!\n");
    while (true) 
    {
        int     read_line = 0;
        timer.reset();
        
        while (timer.read_ms() < 500)
        {
            if (serial.readable() && read_line < sizeof(buffer) - 1)
            {
                buffer[read_line++] = serial.getc();
            }
            
            wait_ms(1);
        }
         buffer[read_line] = 0;
       
        led1 = !led1;
        serial.printf("Led state is %s\r\n", ((led1.read())?"on":"off"));

        
        if (read_line != 0)
        {
            serial.printf("Read Line : %s\r\n", buffer);
        }
        else
        {
            serial.printf("Read line empty!\r\n");
        }
    }
}

