#include <mbed.h>
#include <stdint.h>
#include "MAX31820.h"


extern "C" void $Sub$$SystemInit(void)
{
// 	System clock to the IOCON & the SWM need to be enabled or
// 	most of the I/O related peripherals won't work. 
    LPC_SYSCON->SYSAHBCLKCTRL |= ( (0x1 << 7) | (0x1 << 18) );
    LPC_IOCON->PIO0_8 &= ~(0x3 << 3);				/* remove the pull-up and pull-down resistors	*/
    LPC_IOCON->PIO0_9 &= ~(0x3 << 3);
    LPC_SWM->PINENABLE0 &= ~(0x3 << 4);
    LPC_SYSCON->PDRUNCFG     &= ~(0x1 << 5);        /* Power-up System Osc      */
    LPC_SYSCON->SYSOSCCTRL    = 0x00;
    for (uint8_t i = 0; i < 200; i++) __NOP();

    LPC_SYSCON->SYSPLLCLKSEL  = 0x01;               /* Select PLL Input         */
    LPC_SYSCON->SYSPLLCLKUEN  = 0x01;               /* Update Clock Source      */
    while (!(LPC_SYSCON->SYSPLLCLKUEN & 0x01));     /* Wait Until Updated       */


    LPC_SYSCON->SYSPLLCTRL    = 0x00000023;         /* P=2 (6:5), M=4 (4:0)-> 48MHz*/
    LPC_SYSCON->PDRUNCFG     &= ~(0x1 << 7);        /* Power-up SYSPLL          */
    while (!(LPC_SYSCON->SYSPLLSTAT & 0x01));       /* Wait Until PLL Locked    */

    LPC_SYSCON->MAINCLKSEL    = 0x03;               /* Select PLL Clock Output  */
    LPC_SYSCON->MAINCLKUEN    = 0x01;               /* Update MCLK Clock Source */
    while (!(LPC_SYSCON->MAINCLKUEN & 0x01));       /* Wait Until Updated       */

    LPC_SYSCON->SYSAHBCLKDIV  = 0x01;
}

DigitalInOut sensor(P0_7);     						/* sensor connected to pin 7	*/

int main(){
    SystemCoreClockUpdate();
    Serial pc(USBTX, USBRX);     					/* serial comms over usb back to console	*/
	sensor.mode(PullUp);

    pc.printf("\n\r=====================================================\n\r");
    pc.printf("MAX31820 Configuration\n\r");
    printf("LPC812 SystemCoreClock = %d Hz\n\r", SystemCoreClock);

    ROM_Code_t ROM_Code = ReadROM();
    setResolution(TWELVE_BITS);

    pc.printf("Family code: 0x%X\n\r", ROM_Code.BYTES.familyCode);
    pc.printf("Serial Number: ");
    for (uint32_t i = 6; i != 0; --i) {
        pc.printf("%02X%s", ROM_Code.BYTES.serialNo[i-1], (i != 1)?":":"\r\n");
    }
    pc.printf("CRC: 0x%X\r\n", ROM_Code.BYTES.CRC);
    pc.printf("\n\rRunning temperature conversion...\n\r");

    while (1) {
        displayTemperature(pc);
        wait(2);
    }
}

