#ifndef _MAX31820_
#define _MAX31820_

#include <stdint.h>
#include "mbed.h"

#define	DEVICE				0x28
#define SCRATCHPAD_SIZE		9
#define TH_ALARM			0x7D	// 125ºC
#define TL_ALARM			0xC9	// -50ºC

// Device byte commands over 1-wire serial
enum COMMANDS { READ_ROM = 0x33, CONVERT = 0x44, READ_SCRATCHPAD = 0xBE,
                SKIP_ROM = 0xCC, WRITE_SCRATCHPAD = 0x4E, COPY_SCRATCHPAD = 0x48, MATCH_ROM = 0x55
              };

// Temperature read resolutions
enum RESOLUTION {NINE_BITS , TEN_BITS, ELEVEN_BITS, TWELVE_BITS};

// Device Faimly ID and Setial number information
typedef union {
    uint8_t rom[8];
    struct {
        uint8_t    familyCode;
        uint8_t    serialNo[6];
        uint8_t    CRC;
    } BYTES;
} ROM_Code_t;

ROM_Code_t ReadROM() ;

// device onboard register layout
typedef struct {
    uint8_t    LSB;
    uint8_t    MSB;
    uint8_t    TH;
    uint8_t    TL;
    uint8_t    config;
    uint8_t    reserved0xFF;
    uint8_t    reserved0xCH;
    uint8_t    reserved0x10;
    uint8_t    CRC;
} ScratchPad_t;

// Display temperature
void displayTemperature(Serial& screen) ;
void setResolution(uint8_t resln);

#endif
