#include "mbed.h"
#include "nRF24L01P.h"
#include "MMA8451Q.h"
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)
 
Serial pc(USBTX, USBRX); // tx, rx
 
PinName const SDA = PTE25;
PinName const SCL = PTE24;
 
nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTE1, PTE0, PTD0);    // mosi, miso, sck, csn, ce, irq
 
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
 
int main()
{
 
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    //PwmOut rled(LED1);
    //PwmOut gled(LED2);
    //PwmOut bled(LED3);
 
// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
#define TRANSFER_SIZE   24
 
    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;
 
    my_nrf24l01p.powerUp();
 
    // Display the (default) setup of the nRF24L01+ chip
    //pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    //pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    //pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    //pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    //pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
 
    //pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );
 
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
 
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
 
 
 
    printf("MMA8451 ID: %d\n", acc.getWhoAmI());
 
    while (1) {
 
        float x, y, z;
        x = abs(acc.getAccX());
        y = abs(acc.getAccY());
        z = abs(acc.getAccZ());
        //rled = 1.0f - x;
        //gled = 1.0f - y;
        //bled = 1.0f - z;
        //wait(0.01);
        //txDataCnt =  sprintf(txData, "X:%1.3f,Y:%1.3f,Z:%1.3f\n", x,y,z);
         txDataCnt =  sprintf(txData, "  %1.3f   %1.3f   %1.3f\n", x,y,z);
        printf("X:%f,Y:%f,Z:%f size %i %s\n", x, y, z,txDataCnt, txData);
 
        // If we've received anything over the host serial link...
 
        // ...add it to the transmit buffer
        //txData[txDataCnt++] = pc.getc();
 
        // If the transmit buffer is full
 
        // Send the transmitbuffer via the nRF24L01+
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
        
        printf("sent");
 
        // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
        myled1 = !myled1;
    }
}