#include "mbed.h"
#include "nRF24L01P.h"
#include "MMA8451Q.h"
#include <list>
#include <math.h>
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define TRANSFER_SIZE   8

Serial pc(USBTX, USBRX); // tx, rx

PinName const SDA = PTE25;
PinName const SCL = PTE24;

//int foo=0;
//float x;
//float y;
//float z;

AnalogIn light_ain(A0);
AnalogIn temp_ain(A1);
AnalogIn pir_ain(A2);

nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTE1, PTE0, PTD0);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

float light;
float temp;
float pir;

std::list<float> light_data;
std::list<float> temp_data;
std::list<float> pir_data;

float light_data2[20];
float temp_data2[20];
float pir_data2[20];
short array_ind = 0;

void getdata() {
        
        light = light_ain.read();
        temp = temp_ain.read();
        pir = pir_ain.read();
    
        light_data.push_back(light);
        temp_data.push_back(temp);
        pir_data.push_back(pir);

        light_data.pop_front();
        temp_data.pop_front();
        pir_data.pop_front();
    
        printf("Light reading: %f\n\r", light);  
        printf("Light list element : %f\n\r", light_data.back()); 
    
        printf("Temperature reading: %f\n\r", temp);  
        printf("Temperature list element : %f\n\r", temp_data.back()); 
    
        printf("Temperature reading: %f\n\r", light);
        printf("Pir reading: %f\n\r", pir_data.back());   
 
}

void getdata2() {
    light = light_ain.read();
    temp = temp_ain.read();
    pir = pir_ain.read();
    
    light_data2[array_ind] = light;
    temp_data2[array_ind] = temp;
    pir_data2[array_ind] = pir;
    
    array_ind = (array_ind + 1) % 20;
}


int main(){
        int txDataCnt=0 ;
        int rxDataCnt=0 ;
        char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
        my_nrf24l01p.powerUp();
        my_nrf24l01p.setRfFrequency (2501);
        my_nrf24l01p.setTransferSize(8);
        my_nrf24l01p.setCrcWidth(8);
        my_nrf24l01p.enableAutoAcknowledge(NRF24L01P_PIPE_P0);
        //my_nrf24l01p.setRxAddress(0x00F0F0F0F0);
        my_nrf24l01p.setRxAddress(0xF0F0F0F0E1ULL);
        my_nrf24l01p.setTxAddress(0x00F0F0F0F0);
        //Display the (default) setup of the nRF24L01+ chip
        pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
        pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
        pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
        pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
        pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
        pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );
        my_nrf24l01p.setTransmitMode();
        my_nrf24l01p.enable();
        pc.printf( "Setup complete, Starting While loop\r\n");
        
        //printf("MMA8451 ID: %d\n", acc.getWhoAmI());
        
    
while(1){
        getdata2();
        //txDataCnt =  sprintf(txData, "  %1.4f   %1.4f   %1.4f  %1.4f\n", light_data.back(), light_data.back(), temp_data.back(), pir_data.back());
        //txDataCnt =  sprintf(txData,"  %1.3f   %1.3f   %1.3f\n", light_data2[19], temp_data2[19], pir_data2[19]);
        // Display the (default) setup of the nRF24L01+ chip
        //pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
        //pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
        //pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
        //pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
        //pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
        //txDataCnt= (txDataCnt+1);
        
        //txDataCnt =  sprintf(txData,"%7.3f\n", light_data2[19]);
        printf(txData,sizeof(&txDataCnt));
        my_nrf24l01p.write(NRF24L01P_PIPE_P0, "abcdefgh", 8*sizeof(char));
        wait(0.5);
        printf("Talking...\r\n");
        
        if ( my_nrf24l01p.readable() ) {
                rxDataCnt = my_nrf24l01p.read(NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
                unsigned long *time_ptr = (unsigned long*)rxData; // pointer manipulation split out to make working obvious
                unsigned long time = *time_ptr;                   
                pc.printf("Received %d bytes\n\r", rxDataCnt);
                pc.printf("Value = %d\n\r", time);
               
                txDataCnt=0;
                myled1 = !myled1;
                wait(0.5);
        }

}}


