#include "mbed.h"
#include "nRF24L01P.h"
#include "MMA8451Q.h"
#include <vector>
#include <math.h>

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define TRANSFER_SIZE   24

Serial pc(USBTX, USBRX); // tx, rx

PinName const SDA = PTE25;
PinName const SCL = PTE24;

AnalogIn light_ain(A0);
AnalogIn temp_ain(A1);
AnalogIn pir_ain(A3);

nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTE1, PTE0, PTD0);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

uint16_t light;
uint16_t temp;
uint16_t pir;

std::vector<uint16_t> light_data;
std::vector<uint16_t> temp_data;
std::vector<uint16_t> pir_data;

void getdata()
{
    light = light_ain.read_u16();
    temp = temp_ain.read_u16();
    pir = pir_ain.read_u16();

    light_data.push_back (light);
    temp_data.push_back (temp);
    pir_data.push_back (pir);

    light_data.pop_back();
    temp_data.pop_back();
    pir_data.pop_back();
    
        
    printf("%f\n", light_data);
   
}


int main()
{

    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);

    light_data.assign (20,0);
    temp_data.assign (20,0);
    pir_data.assign (20,0);


    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;

    my_nrf24l01p.powerUp();

    // Display the (default) setup of the nRF24L01+ chip
    //pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    //pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    //pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    //pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    //pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    //pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();

    printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (1) {
        getdata();

        // txDataCnt =  sprintf(txData, "  %1.3f   %1.3f   %1.3f\n", x,y,z);
        //my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
        myled1 = !myled1;
        wait(0.5);
    }

}


