#include "mbed.h"
#include "display_modules.h"
#include "touch_modules.h"
#include "rtc.h"
//#include "main.h"
#include <ILI932x.h>
#include "Arial12x12.h"
#include "Arial24x23.h"
//#include "Terminal6x8.h"
//#include "Arial43x48_numb.h"


//BusOut dataBus( PTC12, PTC13, PTB10, PTC9, PTD4, PTD5, PTD6, PTD7 ); // 16 pins//POC DISPALY 240*320 pixels
//ILI9325_LCD lcd( PTC5, PTB9, PTC0, PTB0, &dataBus, NC, PTE31);

 PinName buspins[8]={PTC12, PTC13, PTB10, PTC9, PTD4, PTD5, PTD6, PTD7 };
 ILI932x TFT(BUS_8, buspins, PTC5, PTB9, PTC0, PTB0,PTE31,"SPFD5408_2.4") ;
DigitalOut backlight(PTC9) ;

 void init_screen()     // initializing the screen
  {    
      //Configure the display driver    
    TFT.FastWindow(true) ;
    TFT.background(Black);
    TFT.foreground(White);
    wait(0.01) ;
    TFT.cls();
  }

 void screen_main()     //main screen
 {
    char buff1[32];
    time_t epoch_time;
    epoch_time=rtc_read();                           // read the time from rtc module
    strftime(buff1, 32, "%d-%m-%Y           %H:%M",localtime(&epoch_time));
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(White) ;
       TFT.cls() ;
      wait(0.1) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Red);
    TFT.locate(20,100) ;
     TFT.printf(buff1);
      TFT.set_font((unsigned char*) Arial24x23);  
       TFT.foreground(Black);
     TFT.locate(35,20) ;
    TFT.printf("SENSESEMI") ;
    TFT.locate(45,60) ;
    TFT.printf("SenseSmart") ;
      TFT.background(Olive) ;
     TFT.fillrect( 60,130,180,200,Olive);
       TFT.locate(100,140) ;
    TFT.printf("SYS") ;    
       TFT.locate(65,170) ;
    TFT.printf("CONFIG") ;    
        TFT.fillrect( 60,230,180,300,Olive);
       TFT.locate(90,250) ;        
       TFT.printf("TEST") ;          
    TFT.BusEnable(false) ;
     backlight = 1 ;
     
  }
     
    
    
    void screen_main_2(int pid)     // test main screen
 {
    char buff2[10];   
       backlight = 0 ;
    TFT.BusEnable(true) ;
  TFT.background(White) ;
  sprintf(buff2 ,"%d", pid);
  TFT.fillrect(5,20,250,150,White ); 
     TFT.fillrect(60,130,180,200,White );  
      TFT.fillrect(60,230,180,300,White ); 
    TFT.set_font((unsigned char*) Arial24x23);
     TFT.foreground(Black);
     TFT.locate(10,50) ;
    TFT.printf("PATIENTID") ;
     TFT.locate(180,50) ;
    TFT.printf(buff2) ;
      TFT.background(Orange) ;
     TFT.foreground(Black);
      TFT.fillrect( 10,130,100,200,Orange);
       TFT.locate(40,160) ;
    TFT.printf("BG") ;   
       TFT.fillrect( 130,130,220,200,Orange);
       TFT.locate(145,160) ;
    TFT.printf("ECG") ;    
        TFT.fillrect( 10,215,100,285,Orange);
       TFT.locate(40,245) ;        
       TFT.printf("BP") ;    
        TFT.fillrect(130,215,220,285,Orange);
       TFT.locate(130,245) ;        
        TFT.printf("HOME") ;    
             
    TFT.BusEnable(false) ;
     backlight = 1 ;
}         
                
                
                
    void screen_main_1() // System Configuration main screen
 {
     backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(GreenYellow) ;
      TFT.fillrect(5,127,230,320,White );  
    // wait(0.1) ;
    TFT.set_font((unsigned char*) Arial24x23);
   TFT.foreground(Black);
      TFT.fillrect( 10,130,100,200,GreenYellow);
       TFT.locate(40,160) ;
    TFT.printf("BLE") ;   
       TFT.fillrect( 130,130,220,200,GreenYellow);
       TFT.locate(135,160) ;
    TFT.printf("ERASE") ;    
        TFT.fillrect( 10,215,100,285,GreenYellow);
       TFT.locate(30,245) ;        
       TFT.printf("FILE") ;    
        TFT.fillrect(130,215,220,285,GreenYellow);
       TFT.locate(130,245) ;        
       TFT.printf("HOME") ;    
             
    TFT.BusEnable(false) ;
     backlight = 1 ;
 }                  
       
                
  void screen_ecg()    //ECG screen 1
   {
       backlight = 0 ;
    TFT.BusEnable(true) ;
      TFT.fillrect(10,130,100,200,White);
     TFT.fillrect(130,130,220,200,White);
      TFT.fillrect(130,215,220,285,White);
       TFT.fillrect(10,215,100,285,White);
       TFT.fillrect(60,130,180,200,White);
     TFT.background(Green) ;   
    TFT.fillrect( 60,130,180,200,Green);
       TFT.locate(80,150) ;
    TFT.printf("START") ;    
         TFT.fillrect( 60,230,180,300,Green);
       TFT.locate(85,250) ;        
       TFT.printf("RET") ;          
    TFT.BusEnable(false) ;
     backlight = 1 ;  
              
              
              
     
     } 
      
      
                
 void screen_ecg_2()   // ECG screen 2
   {
              backlight = 0 ;
            TFT.BusEnable(true) ;
            TFT.background(White) ;
            TFT.foreground(Green) ;
          
          TFT.fillrect(5,90,230,150,White);  
          TFT.locate(3,100) ;  
            TFT.printf("  Tst is Done  ") ;   
            TFT.locate(3,150) ;  
            TFT.printf("   HeartRate   ") ;        
            TFT.locate(3,180);  
            TFT.printf("    72 bpm") ;    
            TFT.background(Green) ;
            TFT.fillrect(10,215,230,290,White);  
            TFT.fillrect(60,230,180,300,Green); 
            TFT.locate(100,250) ;  
            TFT.foreground(Black) ;
            TFT.printf("RET") ;   
            TFT.BusEnable(false) ;
            backlight = 1 ;
        
    }                
       
       
                
 void screen_bp()          // BP main screen
 {
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Green) ;
    TFT.foreground(Black) ;
    TFT.fillrect(10,130,100,200,White);   
    TFT.fillrect(130,130,220,200,White);  
    TFT.fillrect(10,215,100,285,White);  
    TFT.fillrect(130,215,220,285,White);  
    TFT.fillrect( 60,130,180,200,Green);
    TFT.locate(80,150) ;
    TFT.printf("START") ;    
    TFT.fillrect( 60,230,180,300,Green);
    TFT.locate(100,250) ;        
    TFT.printf("RET") ;          
    TFT.BusEnable(false) ;
     backlight = 1 ;     
 
    }
    

 void screen_bp1(float SBP, float DBP)          // BP  screen 2
 {
    backlight = 0 ;
    TFT.BusEnable(true) ;
       TFT.background(White) ;
        TFT.foreground(Green) ;
        char buf[10];  
        TFT.fillrect(3,130,200,200,White);
         TFT.fillrect(60,230,180,300,White);
        sprintf (buf, "SBP: %.0f   ",SBP);          // changed to display 2 digits after decimal point, 2May'17 Changed to Integer
        TFT.locate(5,100) ;
    TFT.printf(buf) ; 
         sprintf (buf, "DBP: %.0f",DBP);           // changed to display 2 digits after decimal point, 2May'17, Changed to integer
          TFT.locate(5,150) ;
        TFT.printf(buf) ;
        TFT.fillrect(60,230,180,300,Green);
         TFT.locate(85,250) ;  
            TFT.foreground(Black) ;
             TFT.background(Green) ;
         TFT.printf("RET") ;    
          TFT.BusEnable(false) ;
     backlight = 1 ; 
}   
    
    
                   
                
  
 void screen_glc()     // glc main screen
 {
        
         backlight = 0 ;
    TFT.BusEnable(true) ;
      TFT.background(Green) ;
        TFT.foreground(Black) ;
     TFT.fillrect(10,130,100,200,White);
       TFT.fillrect(130,130,220,200,White);
         TFT.fillrect(10,215,100,285,White);
           TFT.fillrect(130,215,220,285,White);
        TFT.fillrect( 60,130,180,200,Green);
       TFT.locate(80,150) ;
    TFT.printf("START") ;    
         TFT.fillrect( 60,230,180,300,Green);
       TFT.locate(100,250) ;        
       TFT.printf("RET") ;          
    TFT.BusEnable(false) ;
     backlight = 1 ; 
        
    }               


 void screen_bp2()    //BP screen 3
 {    
     
          /* lcd.FillRoundRect(3,130,200,200,COLOR_BLACK);
           lcd.FillRoundRect(60,230,180,300,COLOR_BLACK);
           lcd.FillRect(5,215,230,290,COLOR_BLACK);*/
           
}
            
     
 void ecg_countdown()   // ECG measurement countdown 
 {    
        backlight = 0 ;
    TFT.BusEnable(true) ;
       TFT.background(White) ;
        TFT.foreground(Green) ;
        char tim1[5];
           TFT.fillrect(3,130,200,200,White);
           TFT.fillrect(60,230,180,300,White);
           TFT.fillrect(5,215,230,290,White);
         TFT.locate(25,100) ;        
       TFT.printf("ECG starts in") ; 
         for(int i=5;i>=0;i--)
            {
                wait(1);
                sprintf (tim1, "%d",i);
                TFT.locate(120,120) ;        
                 TFT.printf(tim1) ; 
            }
     TFT.BusEnable(false) ;
     backlight = 1 ; 
        
      
  }                
  
   void bp_countdown()   // ECG measurement countdown 
 {    
     backlight = 0 ;
    TFT.BusEnable(true) ;
       TFT.background(White) ;
        TFT.foreground(Green) ;
        char tim1[5];
           TFT.fillrect(3,130,200,200,White);
           TFT.fillrect(60,230,180,300,White);
           TFT.fillrect(5,215,230,290,White);
         TFT.locate(25,100) ;        
       TFT.printf("BP starts in") ; 
         for(int i=5;i>=0;i--)
            {
                wait(1);
                sprintf (tim1, "%d",i);
                TFT.locate(120,120) ;        
       TFT.printf(tim1) ; 
            }
     TFT.BusEnable(false) ;
     backlight = 1 ; 
} 
  
 void screen_again()    // screen to press 'yes' or 'no' to repeat the test 
 { 
   backlight = 0 ;
   TFT.BusEnable(true) ;
   TFT.background(White) ;
        TFT.foreground(Black) ;
            TFT.fillrect(5,127,230,200,White);
            TFT.locate(50,130) ; 
            TFT.printf("Take test") ;
             TFT.locate(75,160) ; 
            TFT.printf("again?") ;
             TFT.background(Orange) ;
            TFT.locate(30,245) ;  
               TFT.printf("YES") ;
                 TFT.locate(135,245) ;  
               TFT.printf(" NO ") ;
     backlight = 1 ; 
    TFT.BusEnable(false) ;
   
  }
  
  
  void screen_glc_2()   // GLC screen 3 after test 
   {
       
     backlight = 0 ;
    TFT.BusEnable(true) ;
       TFT.background(White) ;
        TFT.foreground(Black) ;
            TFT.fillrect(5,127,230,320,White);
          TFT.fillrect(60,230,180,300,Green);
         TFT.locate(85,250) ;  
          TFT.background(Green); 
        TFT.printf("RET") ;    
          backlight = 1 ; 
          TFT.BusEnable(false) ;
   
          
          
    }  
  
  
  void glc_1()     // GLC screen 
  { 
        backlight = 0 ;
       TFT.BusEnable(true) ;
       TFT.background(White) ;
        TFT.foreground(Magenta ) ;
        TFT.fillrect(3,130,200,200,White);
        TFT.fillrect(60,230,180,300,White);
         TFT.fillrect(5,215,230,290,White);
         TFT.locate(5,130) ;  
        TFT.printf("Blood Glucose") ; 
        TFT.locate(5,160) ;  
        TFT.printf("Insert strip") ; 
      TFT.BusEnable(false) ;
     backlight = 1 ; 
  
  
  
  }
  
   void glc_2()     // GLC screen 
  {
      backlight = 0 ;
       TFT.BusEnable(true) ;
        TFT.locate(5,160) ;  
        TFT.printf("Strip Detected") ; 
        TFT.locate(5,190) ;  
        TFT.printf("Insert Blood") ; 
      TFT.BusEnable(false) ;
     backlight = 1 ; 
   }
   
 
  void glc_3()     // GLC screen 
  {
      backlight = 0 ;
       TFT.BusEnable(true) ;    
        TFT.locate(5,190) ;  
        TFT.printf("Blood Detected") ; 
        TFT.locate( 5,220) ;  
        TFT.printf("computing") ; 
      TFT.BusEnable(false) ;
     backlight = 1 ; 
     }
   
  
  void glc_4(unsigned int mgdl)   // GLC screen to display blood glucose level on the LCD
   { 
      char buf[10];
     sprintf (buf, " BG %d mg/dl",mgdl);
       backlight = 0 ;
       TFT.BusEnable(true) ;
        TFT.fillrect(5,127,230,320,White);
      TFT.locate(5,100) ;  
    TFT.printf(buf) ; 
      TFT.BusEnable(false) ;
     backlight = 1 ; 
   }