
//BP Optimised Program for Averaging the received value from PPG and ECG & Check for SD card Storage//


/** ECG ADS1291 Test program.
ADS1291 is a single channel ECG chip
with a 24 bit Sigma-Delta ADC
 */

/* 
#include "mbed.h"
#include "MAX30102.h" // BP ADD
#include <string.h>
#include <stdio.h>
#include "ds3231.h"
#include "SDFileSystem.h"
#include "rtc.h"
#include "sdcard.h"
#include "ec_bp.h"
#include "bp.h"
#include "display_modules.h"


Serial bc(USBTX,USBRX);
DigitalIn INTR(PTC7);

 
    
void bp() {
 
//------------------BP ADD------------------------------//{ 
//int location; // BP ADD
int32_t n_red_buffer_length = 1500;    //data length
uint32_t aun_red_buffer[1500];    //Red LED sensor data, set to 500
uint32_t red_value;
uint32_t ecg_value;
uint8_t uch_dummy;
uint32_t ecg_buf[1000];
int32_t ecg_buffer_length = 1000;
float SBP, DBP, PWV, delta_t;
int d = 210;

uint32_t un_min, un_max, ecg_min, ecg_max ;  //variables to calculate the on-board LED brightness that reflects the heartbeats
    //int i, j;
    float ecg_location, ppg_location; 
    //int32_t n_brightness;
    
   // n_brightness=0;
    un_min=0x3FFFF;
    un_max=0;
    ecg_min = 0xFFFFFF;
    ecg_max = 0;
 //---------------- BP ADD-----------------------------//}
 
 
 //time_t epoch_time;
  //int fp;
 int concatenate_value1 = 0;
//uint32_t ecg_buf[1500];
//int32_t ecg_der[1500];
//int buff1[15]= {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
//int32_t sample_sum; // static int32_t avg[1500];
 //int32_t count = 0; int32_t fs = 500; int32_t w=0,w1=0;

   unsigned char chk = 1;
    bc.baud(baud_rate);
   // mySpi.frequency(freq) ;
   // mySpi.format(bits, mode) ; 
 freqset();
  //  Ds3231 rtc(PTC11, PTC10); //sda,scl2yy
   
   //------------------BP ADD---------------------------// {
    while(bc.readable()==0)
    {
        bc.printf("\x1B[2J");  //clear terminal program screen
        bc.printf("Press any key to start conversion\n\r");
        wait(1);
    }
  wait(5);
  bc.printf("Start of capture, Remain CALM and Donot MOVE\n");  
  wait(2);
  //-------------------BP ADD---------------------------//}
    
  setupfunc();
  ecgsetupfunc(); 
  //--------------- BP ADD------------------------------------//{
  maxim_max30102_reset();  // PPG reset
  maxim_max30102_init(); // PPG ADC register Initialise 
  //---------------BP ADD ----------------------------------// }  
  
 
   chk = 1;
 bc.printf("rawecg......................\n");
 for(int i=0; i<N_ECG; i++)
 {
    
     concatenate_value1=readvalue();
    ecg_buf[i] = concatenate_value1;
   
    bc.printf( "%d\n", concatenate_value1);
    maxim_max30102_read_reg(0,&uch_dummy);
    while(INTR.read()==1); 
    maxim_max30102_read_fifo((aun_red_buffer+i)); 
     //bc.printf( "%d\n", concatenate_value1);
      // bc.printf("%d\n",aun_red_buffer[i]);
    //sd_write(concatenate_value); - -- BP ADD commented
    //printf( "%d\n", concatenate_value); -- BP ADD commented
    // bc.printf("loop2");
    }
    
  for (int w=1000; w < n_red_buffer_length; w++)  // for reading extra 500 PPG samples.
  {
 //bc.printf("loop2");
  while(INTR.read()==1);
  maxim_max30102_read_fifo((aun_red_buffer+w));
  } 


   //sd_close();  -- BP ADD commented
   
   int32_t ecg_n_denom;

 // 4 pt Moving Average ECG
    bc.printf("PRINTING ECG 4 POINT IN DECIMAL........\n");
    for(int y=0; y<996; y++){
        ecg_n_denom= ( ecg_buf[y]+ ecg_buf[y+1]+ ecg_buf[y+2]+ ecg_buf[y+3]);
        ecg_buf[y]=  ecg_n_denom/(int32_t)4;
    }
    for( int l= 0; l<1000; l++){
    bc.printf("%d\n",ecg_buf[l]); //PRINTING ecg AFTER AVERAGING
    }
bc.printf("PRINTING PPG IN DECIMAL (after averaging)........\n");
int32_t ppg_n_denom;
  // 4 pt Moving Average PPG
    for(int f=0; f<1496; f++){
        ppg_n_denom= ( aun_red_buffer[f]+aun_red_buffer[f+1]+ aun_red_buffer[f+2]+ aun_red_buffer[f+3]);
        aun_red_buffer[f]= ppg_n_denom/(int32_t)4;
    }
    for( int b = 0; b<1500; b++){
       bc.printf("%d\n",aun_red_buffer[b]);
    }
    

for(int f=0; f<ecg_buffer_length; f++)
   {
       if(ecg_min > ecg_buf[f])
           ecg_min = ecg_buf[f];    //update signal min
        if(ecg_max < ecg_buf[f])
        {
            ecg_max=ecg_buf[f];    //update signal max
            ecg_location = f+1;
    }
    }
    bc.printf( "ecg_location = %f\n", ecg_location);

for(int g = ecg_location;  g < (ecg_location+400); g++) // Peak detect changed to 400 samples from 500 samples
    {
       if(un_min>aun_red_buffer[g])
           un_min=aun_red_buffer[g];    //update signal min
        if(un_max<aun_red_buffer[g])
        {
            un_max=aun_red_buffer[g];    //update signal max
            ppg_location = g+1;
    }
    }
bc.printf( "ppg_location = %f\n", ppg_location);

delta_t = (2*(ppg_location - ecg_location))/1000;
bc.printf( "delta_t = %f\n", delta_t);

PWV = d/delta_t;
bc.printf( "PWV = %f\n", PWV);

SBP = 0.0508955*PWV+62.559;
DBP = 0.0494*PWV + 17.480;


bc.printf( "SBP = %f\n", SBP);
bc.printf( "DBP = %f\n", DBP);

screen_bp1(SBP,DBP);
*/

//-----------------WRITE ECG &PPG
 /*  
sd_open_BPfile(1);
for (int w=0; w < 1000; w++)
{
ecg_value =  ecg_buf[w];   
sd_write(ecg_value);
}



for (int w=0; w < n_red_buffer_length; w++)
{
red_value =  aun_red_buffer[w];   
sd_write(red_value); 
}
sd_close();*/

//----------- FINISHED WRITING ECG & PPG TO SD CARD

   

        
 //}    // End of main function


//-----------------------------------------------NEW BP code starts--------------------------------///

#include "mbed.h"
#include "MAX30102.h" // BP ADD
#include <string.h>
#include <stdio.h>
//#include <iostream>
#include "ds3231.h"
#include "SDFileSystem.h"
#include "rtc.h"
#include "sdcard.h"
#include "ec_bp.h"
#include "bp.h"
#include "display_modules.h"

using namespace std;

Serial bc(USBTX,USBRX);
DigitalIn INTR(PTC7);

Timer t; 

//FILE *ecg;
//FILE *ppg;
    
void bp(int pid) {
    uint8_t uch_dummy;
    uint32_t ppgdata; 

    //int dummyconcat = 700000;
    int concatenate_value2 = 0;
    unsigned char chk = 1;

    int drum11[64];
    uint32_t drum21[64];

    // Variables for file operations
   // uint32_t amax=0;
    //uint32_t bmax = 0;
    //uint32_t a;
    //uint32_t b;
    
   //int aloc = 0;
   //int bloc = 0;
   //int samples = 0;

    bc.baud(baud_rate);

    freqset();               // setting the frequency
    setupfunc();              
    ecgsetupfunc();
        
    maxim_max30102_reset();  // PPG reset
    wait_ms(20);
    maxim_max30102_init();
        
    chk = 1;
        
    wait(2);
    //bc.printf("BP start\n");  

    for(int i=0; i<500; i++)
    {
        
        concatenate_value2= readvalue();
        
        maxim_max30102_read_reg(0,&uch_dummy);
        while(INTR.read()==1); 
        maxim_max30102_read_fifo(&ppgdata); 
            
    }   


    sd_open_BP_ECGfile(pid) ; //   sd_open_BP_ECGfile(123) draft file for testing
    sd_open_BP_PPGfile(pid) ; // sd_open_BP_PPGfile(123) draft file for testing

    FILE *ecg = NULL;
    FILE *ppg = NULL;
    int *drum_ecg = NULL; // pointers to ecg buffer
    uint32_t *drum_ppg = NULL; // pointer to ppg buffer
    
    drum_ecg = drum11;
    drum_ppg = drum21;
    
    for(int j =0 ; j<16; j++) // changed to 16 from 8
    {
        for(int i=0; i<64; i++)
        {
            concatenate_value2 = readvalue();
            drum11[i]=concatenate_value2;   //drum11[i]=concatenate_value2;      drum11[i]=dummyconcat;
         
            maxim_max30102_read_reg(0,&uch_dummy);
            while(INTR.read()==1); 
            maxim_max30102_read_fifo(&ppgdata); 
            drum21[i]=ppgdata;    
        }
                           
            ecg = sd_BP_ecgwrite(drum_ecg); //
            ppg = sd_BP_ppgwrite(drum_ppg);
        
        
    } 
    
    for(int j =0 ; j<10; j++) // changed to 16 from 8
    {
        for(int i=0; i<64; i++)
        {
            maxim_max30102_read_reg(0,&uch_dummy);
            while(INTR.read()==1); 
            maxim_max30102_read_fifo(&ppgdata); 
            drum21[i]=ppgdata; 
        }
        
         ppg = sd_BP_ppgwrite (drum_ppg);
        
     }  
    fclose(ecg);
    fclose(ppg);
     
    maxim_max30102_reset();
    
    //-----Reading from file starts //
    
    //std::ifstream ec1("/sd/123_BP_ECG.csv");
    //std::ifstream pp1("/sd/123_BP_PPG.csv");
    
    int eloc = 0;
    int ploc = 0;
   
   
   eloc = sd_BP_ECGMAX(pid); // eloc = sd_BP_ECGMAX(123);
   ploc = sd_BP_PPGMAX(pid); // ploc = sd_BP_PPGMAX(123);
    
   //bc.printf("The ECG max is at : %d", eloc);
   //bc.printf("The PPG Max is at : %d", ploc);
   
   float PWV = 0;
   int d = 210000;
   int delta_t = 0;
   float SBP = 0;
   float DBP = 0;
   
   delta_t  = (2*(ploc - eloc));
   PWV = d/delta_t;
   
    SBP = 0.0508955*PWV+62.559;
    DBP = (0.0494*PWV + 17.480)+10;
    
    screen_bp1(SBP,DBP);
    
    create_single_BPfile(pid);
 
 }