const int REMINDER_SIZE = 17;


// speech synthesis
//1 2 3 4 5 6 7 8 9 10 11 12 15 50 40 30 20
static const int synTime[] = {11, 19, 16, 7, 5, 21, 13, 1, 8, 14, 2, 17, 3, 4, 6, 15, 18};
//o'clock, OH, reminder, appointment, AM, PM, Taken Meds?, Thank You
static const int synWords[] = {9, 10, 12, 20 ,22, 24, 23, 25};

enum Day {Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday};

struct reminder {
    //struct tm tm_time;
    int hour;
    int min;
    int reminder_days[7]; /* set all days to 0. If day is used, set to 1
    If no day specified (ie every day), set all to 1 */
    //time_t timet_time; // represents the number of seconds since the start of the Unix epoch: midnight UTC of January 1, 1970
    string notification;
    int taken;
    int nottaken;
};

struct dateTime {
    int month;
    int day;
    int year;
};

struct record {
    vector<struct dateTime> date;
    vector<int> data;
    int record_number;
};


class schedule
{
    // will be ordered by time - should do this processing on the desktop
    vector<struct reminder> reminder_list;
    int size;
    int index;
    vector<struct record> schedule_record;
public:
    schedule();
    void addReminder(reminder);
    reminder getCurrentReminder();
    reminder nextReminder();
    int getSize();
    void updateRecord(struct dateTime rDate, int dataIn);
    int getNumRecords(int recordnum);
    record getRecord(int recordnum);
};

schedule::schedule()
{
    size = 0;
    index = 0;
}

void schedule::addReminder(reminder add)
{
    reminder_list.push_back(add);
    size++;
    // create record for every new reminder
    record tmp;
    tmp.record_number = size - 1; // record numbers start at 0;
    schedule_record.push_back(tmp);
}

reminder schedule::getCurrentReminder()
{
    /*
    if (size > index) {
        index++;
        return reminder_list[index];
    }
    else {
        if (index != 0) {
            index = 0;
            return reminder_list[index];
        }
        //return -1;
    }
    // should throw error here...
    reminder emptyReminder;
    return emptyReminder;*/
    return reminder_list[index];
}

int schedule::getSize()
{
    return size;
}

reminder schedule::nextReminder()
{
    if (index < (size - 1))
        index++;
    else index = 0;
    return reminder_list[index];
}

void schedule::updateRecord(struct dateTime dateIn, int dataIn)
{
    schedule_record[index].date.push_back(dateIn);
    schedule_record[index].data.push_back(dataIn);
}

int schedule::getNumRecords(int recordnum)
// returns how many data entries are in a record
{
    return schedule_record[recordnum].data.size();
}

record schedule::getRecord(int recordnum)
{
    return schedule_record[recordnum];
}
