//Linear Actuator to control the moving rod. 
/*
#include "mbed.h"
#include "Motor.h"
#include "PinDetect.h"

float moving_time1 = 15.0;            //we control the Table Actuator stop position by play with the moving time1; longer rising time,higher stop position
float moving_time2 = 20.0;            //we control the Connector Actuator stop position by play with the moving time2; longer rising time,higher stop position
float charging_time = 20.0;           //the time needed to charge the battery, during which the Connector Actuator will stay at its highest position
float wait_time = 3.0;               //time waiting for the drone to slide to the triangle hindge
float hold_time = 3.0;               //the time during which the Table Actuator will stay at its highest position after disconnected the connector
int running_schedule = 0;            //0-resting  1-running the schedule
int is_reset = 0;

DigitalOut led(LED1);
Motor m1(p21, p27, p28);        // pwm, fwd, rev //Table Actuator
Motor m2(p22, p10, p9);          // pwm, fwd, rev //Connector Actuator
PinDetect load_sensor(p5);
PinDetect start(p6);
PinDetect reset(p7);

void start_the_schedule(){
    running_schedule = 1;       //when the load sensor sense the drone or the start putton is pressed, change to 1;
    led = !led;    
}

void reset_to_zero(){
    m2.speed(-1);           //Connector Actuator Goging down
    wait(moving_time2);
    m2.speed(0);            //Connector Actuator Stops at the start position
    m1.speed(-1);           //Connector Actuator Goging down
    wait(moving_time1);
    m1.speed(0);            //Table Actuator Stops at the start position
}


int main() {
    load_sensor.mode(PullUp); wait(0.01);
    load_sensor.attach_deasserted(&start_the_schedule);
    load_sensor.setSampleFrequency();
    start.mode(PullUp); wait(0.01);
    start.attach_deasserted(&start_the_schedule);
    start.setSampleFrequency();
    reset.mode(PullUp); wait(0.01);
    reset.attach_deasserted(&reset_to_zero);
    reset.setSampleFrequency();
    
   
    while(1) {
        // m1.speed(-1);           //Connector Actuator Goging down
        //wait(moving_time1);
        //m1.speed(0);
        m2.speed(-1);           //Connector Actuator Goging down
            wait(moving_time2);
            m2.speed(0); 
        while(running_schedule){
            if(reset) break;
            m1.speed(1);            //Table Actuator Going Up
            wait(moving_time1);
            m1.speed(0);            //Table Actuator Stops at its Highest Position
            if(reset) break;
            wait(wait_time);        //Waiting for the quadcoptor to slide into the triangle hindge
            if(reset) break;
            m2.speed(1);            //Connector Actuator Going Up
            wait(moving_time2);
            m2.speed(0);            //Connector Actuator Stops at its Highest Position
            if(reset) break;
            wait(charging_time);    //Waiting for the battery to charging 
            if(reset) break;
            m2.speed(-1);           //Connector Actuator Goging down
            wait(moving_time2);
            m2.speed(0);            //Connector Actuator Stops at the start position
            if(reset) break;
            wait(hold_time);        //Waiting for the quadcoptpr to take off
            if(reset) break;
            m1.speed(-1);           //Connector Actuator Goging down
            wait(moving_time1);
            m1.speed(0);            //Table Actuator Stops at the start position
            running_schedule = 0;   //change back to resting after finished the whole loop
        }
        is_reset = 0;                  //Either finishe the schedual natually, or break from the loop, set reset back to 0
        running_schedule = 0;       //and rest the system 
    }  
  
}

*/

#include "mbed.h"
#include "Motor.h"
#include "PinDetect.h"

float moving_time1 = 10.0;            //we control the Table Actuator stop position by play with the moving time1; longer rising time,higher stop position
float moving_time2 = 20.0;            //we control the Connector Actuator stop position by play with the moving time2; longer rising time,higher stop position
float charging_time = 20.0;           //the time needed to charge the battery, during which the Connector Actuator will stay at its highest position
float wait_time = 3.0;                //time waiting for the drone to slide to the triangle hindge
float hold_time = 3.0;                //the time during which the Table Actuator will stay at its highest position after disconnected the connector
bool running_schedule = 0;            //0- the system is resting  1-running schedule
bool is_reset=0;                      // Used to activate reset function

const float pulse_width = 0.2;        // Define width of the pulse

Motor m1(p21, p27, p28);              // pwm, fwd, rev //Table Actuator
Motor m2(p22, p10, p9);               // pwm, fwd, rev //Connector Actuator
PinDetect load_sensor(p5);
PinDetect start(p6);
PinDetect reset(p7);
DigitalOut led(LED1);
DigitalOut led2(LED2);

//********************************************* Pb Interrupt Functions **************************************************

void start_the_schedule()
{
    running_schedule = 1;       //when the load sensor sense the drone or the start putton is pressed, change to 1;    
}

void break_loop()
{
    is_reset = 1;               // intterup to reset
}

//********************************************* Actuator Control Functions **************************************************
void raise(Motor& m,const float& pls_wid)
{   //send a rising command pulse to Motor m
    m.speed(1);
    wait(pls_wid);
    m.speed(0);
}

void fall(Motor& m,const float& pls_wid)
{   //send a falling command pulse to Motor m 
    m.speed(-1);
    wait(pulse_width);
    m.speed(0);
}

void hold()
{   //send a wait command pulse
    wait(0.2);  
}

//********************************************* Functions for Base Station System *********************************************************
void reset_schedule()
{
    led = 0;
    for(int i = 0; i<(moving_time2/pulse_width);i++){
         fall(m2,pulse_width);   
    }    
    for(int i = 0; i<(moving_time1/pulse_width);i++){
         fall(m1,pulse_width);   
    } 
    is_reset = 0;
}

void schedule()
{
    for(int i=0;i<(moving_time1/pulse_width);i++)    //Table Actuator lift the table up
    {   if(is_reset){reset_schedule();return;}
        led = !led;
        raise(m1,pulse_width);
    }
    led2 = 1;
    wait(0.2);
    led2 = 0;
    for(int i=0;i<(wait_time/pulse_width);i++)       //Waiting for the quadcoptor to slide into the triangle hindge
    {   if(is_reset){reset_schedule();return;}
        led = !led;
        hold();
    }
    led2 = 1;
    wait(0.2);
    led2 = 0;
    for(int i = 0; i<(moving_time1/pulse_width);i++) //Table Actuator goes down
    {   if(is_reset){reset_schedule();return;}
        led = !led;
        fall(m1,pulse_width);   
    } 
    led2 = 1;
    wait(0.2);
    led2 = 0; 
    for(int i = 0; i<(moving_time2/pulse_width);i++) //Connector Actuator lifts up
    {   if(is_reset){reset_schedule();return;}
        led = !led;
        raise(m2,pulse_width);   
    } 
    led2 = 1;
    wait(0.2);
    led2 = 0;
    for(int i=0;i<(charging_time/pulse_width);i++)   //Waiting for the battery to charge
    {   if(is_reset){reset_schedule();return;}
        led = !led;
        hold();
    }
    led2 = 1;
    wait(0.2);
    led2 = 0;
    for(int i = 0; i<(moving_time2/pulse_width);i++) //Connector Actuator goes down
    {   if(is_reset){reset_schedule();return;}
        led = !led;
        fall(m2,pulse_width);   
    } 
    led2 = 1;
    wait(0.2);
    led2 = 0;
    for(int i=0;i<(hold_time/pulse_width);i++)       //Waiting for the quadcoptpr to take off
    {   if(is_reset){reset_schedule();return;}
        led = !led;
        hold();
    }      
    led2 = 1;
    wait(0.2);
    led2 = 0;
          
}

//********************************************* Main Function *********************************************************
int main()
{
    //init interuppt
    load_sensor.mode(PullUp); wait(0.01);
    load_sensor.attach_deasserted(&start_the_schedule);
    load_sensor.setSampleFrequency();
    start.mode(PullUp); wait(0.01);
    start.attach_deasserted(&start_the_schedule);
    start.setSampleFrequency();
    reset.mode(PullUp); wait(0.01);
    reset.attach_deasserted(&break_loop);
    reset.setSampleFrequency();
    while(1){
        led = 1;
        if(running_schedule){
            schedule();
            running_schedule = 0;       //return to reset after finish the schedule
        }
        if(is_reset){
            reset_schedule();
        }
    }
}

