#include "main.h"

int32_t delay=0;
uint32_t AppStatus = 0x00;
FlagStatus AppLaunched = RESET;
uint8_t DemoIndex = 0;

/* initialization variable */
__IO FlagStatus KeyPressed = RESET;
FlagStatus JoyInitialized = RESET;
FlagStatus IddInitialized = RESET;
FlagStatus LcdInitialized = RESET;
FlagStatus LedInitialized = RESET;

JOYState_TypeDef JoyState = JOY_NONE;

__IO uint8_t NbLoop = 1;

/* Volume of the audio playback */
/* Initial volume level (from 50% to 100% (Max)) */
__IO uint8_t Volume = 70;
__IO uint8_t VolumeChange = 0;
__IO uint8_t AudioPlaybackExit = 0;
__IO uint8_t AudioRecordExit = 0;
__IO uint8_t AudioRecordSampleRateSelected = 0;  
__IO uint8_t SampleRateIndex = 0;
__IO uint8_t AudioRecordSampleRateChange = 0;

extern __IO uint8_t bLCDGlass_KeyPressed;
extern FlagStatus IddItOccurred;
extern uint8_t IddIndex;



typedef enum
{
  DEMO_STATE_LED            = 0x00,   /*!< Led application launched */
  DEMO_STATE_JOYSTICK,                /*!< Joystick application launched */
  DEMO_STATE_LCD ,                    /*!< LCD application launched */
  DEMO_STATE_AUDIO_RECORD,            /*!< Audio record application launched */
  DEMO_STATE_FIRST_STARTUP,           /*!< Demo first Startup */
  DEMO_STATE_IDLE,                    /*!< Demo in idle */
} Demo_StateTypeDef;

/* Private function prototypes -----------------------------------------------*/
static void Display_DemoDescription(void);

BSP_DemoTypedef  BSP_examples[]=
{
  {AudioRecord_demo, "AUDIO RECORD", DEMO_STATE_AUDIO_RECORD}
};

 int main(void)
{
  uint8_t i = 0;
  uint8_t menudisplay[DEMO_NAME_CHAR_NB + 5] = {0};
  
  /* STM32L4xx HAL library initialization:
       - Configure the Flash prefetch
       - Systick timer is configured by default as source of time base, but user 
         can eventually implement his proper time base source (a general purpose 
         timer for example or other time source), keeping in mind that Time base 
         duration should be kept 1ms since PPP_TIMEOUT_VALUEs are defined and 
         handled in milliseconds basis.
       - Set NVIC Group Priority to 4
       - Low Level Initialization
     */
  HAL_Init();

  /*##-1- Configure the system clock #########################################*/
  /*  */
  SystemClock_Config(); 

  /*##-2-Configure minimum hardware resources at boot ########################*/
  SystemHardwareInit();
  
    /* Display demo explaination on LCD Glass */
    AppStatus = DEMO_STATE_FIRST_STARTUP;
    Display_DemoDescription();

  /* Menu display first characters initialization */
  for(i = 0; i < 5; i++)
  {
    menudisplay[i] = ' ';
  }


  /* Wait For User inputs */
  while (1)
  {
     for(i = 0; i < DEMO_NAME_CHAR_NB; i++)
     {
       menudisplay[i+5] = BSP_examples[DemoIndex].DemoName[i];
     }
      
      BSP_LCD_GLASS_ScrollSentence(menudisplay, 1, SCROLL_SPEED_HIGH);

      if(AppLaunched != RESET)
      {
        AppLaunched = RESET;
        KeyPressed = RESET;
        
        /* Clear screen */
        BSP_LCD_GLASS_Clear();

        /* Set Application status in case of specific joystick usage */
        AppStatus = BSP_examples[DemoIndex].DemoIndex;

        /* launched application */
        BSP_examples[DemoIndex].DemoFunc();
        
        /* Set Application status to Idle */
        AppStatus = DEMO_STATE_IDLE;
        
        /* Notify end of test and clear screen */
        BSP_LCD_GLASS_ScrollSentence((uint8_t *)"      END OF TEST", 1, SCROLL_SPEED_HIGH);
        BSP_LCD_GLASS_Clear();
      }
  }
}

void SystemClock_Config(void)
{
  /* oscillator and clocks configs */
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  
  /* The voltage scaling allows optimizing the power consumption when the device is
     clocked below the maximum system frequency, to update the voltage scaling value
     regarding system frequency refer to product datasheet.  */

  /* Enable Power Control clock */
  __HAL_RCC_PWR_CLK_ENABLE();

  if(HAL_PWREx_ControlVoltageScaling(PWR_REGULATOR_VOLTAGE_SCALE1) != HAL_OK)
  {
    /* Initialization Error */
    Error_Handler();
  }

  /* Disable Power Control clock */
  __HAL_RCC_PWR_CLK_DISABLE();

  /* 80 Mhz from MSI 8Mhz */
  /* MSI is enabled after System reset, activate PLL with MSI as source */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_MSI;
  RCC_OscInitStruct.MSIState = RCC_MSI_ON;
  RCC_OscInitStruct.MSIClockRange = RCC_MSIRANGE_7;
  RCC_OscInitStruct.MSICalibrationValue = RCC_MSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_MSI;
  RCC_OscInitStruct.PLL.PLLM = 1;
  RCC_OscInitStruct.PLL.PLLN = 20;
  RCC_OscInitStruct.PLL.PLLR = 2;
  RCC_OscInitStruct.PLL.PLLP = 7;
  RCC_OscInitStruct.PLL.PLLQ = 4;

  if(HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    /* Initialization Error */
    Error_Handler();
  }
  
  /* Select PLL as system clock source and configure the HCLK, PCLK1 and PCLK2 
     clocks dividers */
  RCC_ClkInitStruct.ClockType = (RCC_CLOCKTYPE_SYSCLK | RCC_CLOCKTYPE_HCLK | RCC_CLOCKTYPE_PCLK1 | RCC_CLOCKTYPE_PCLK2);
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;
  if(HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_4) != HAL_OK)
  {
    /* Initialization Error */
    Error_Handler();
  }
  
  /* The voltage scaling allows optimizing the power consumption when the device is
     clocked below the maximum system frequency, to update the voltage scaling value
     regarding system frequency refer to product datasheet.  */

  /* Enable Power Control clock */
  __HAL_RCC_PWR_CLK_ENABLE();

  if(HAL_PWREx_ControlVoltageScaling(PWR_REGULATOR_VOLTAGE_SCALE1) != HAL_OK)
  {
    /* Initialization Error */
    Error_Handler();
  }

  /* Disable Power Control clock */
  __HAL_RCC_PWR_CLK_DISABLE();
}

void SystemLowClock_Config(void)
{
  /* oscillator and clocks configs */
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  uint32_t flatency = 0;

  /* Retrieve clock parameters */
  HAL_RCC_GetClockConfig(&RCC_ClkInitStruct, &flatency );
  
  /* switch SYSCLK to MSI in order to modify PLL divider */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_SYSCLK;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_MSI;
  if(HAL_RCC_ClockConfig(&RCC_ClkInitStruct, flatency) != HAL_OK)
  {
    /* Initialization Error */
    Error_Handler();
  }
  
  /* Retrieve oscillator parameters */
  HAL_RCC_GetOscConfig(&RCC_OscInitStruct);
  
  /* turn off PLL */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_NONE;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_OFF;
  if(HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    /* Initialization Error */
    Error_Handler();
  }
}

/**
  * @brief  System Power Configuration at Boot
  * @param  None
  * @retval None
  */
void SystemHardwareInit(void)
{
  /* Init LED4 and LED5  */
  if(LedInitialized != SET)
  {
    BSP_LED_Init(LED_RED);
    BSP_LED_Init(LED_GREEN);
    LedInitialized = SET;
  }
  
  /* Init STM32L476G-Discovery joystick in interrupt mode */
  if(JoyInitialized != SET)
  {
    BSP_JOY_Init(JOY_MODE_EXTI);
    JoyInitialized = SET;
  }
  
  /* Initialize the LCD */
  if(LcdInitialized != SET)
  {
    BSP_LCD_GLASS_Init();
    LcdInitialized = SET;
  }
  __HAL_RCC_I2C2_CLK_ENABLE();
}

/**
  * @brief  System Low Power Configuration
  * @param  None
  * @retval None
  */
void SystemHardwareDeInit(void)
{
  if(LedInitialized != RESET)
  {
    BSP_LED_DeInit(LED_RED);
    BSP_LED_DeInit(LED_GREEN);
    LedInitialized = RESET;
  }

  if(JoyInitialized != RESET)
  {
    BSP_JOY_DeInit();
    JoyInitialized = RESET;
  }

  if(LcdInitialized != RESET)
  {
    BSP_LCD_GLASS_DeInit();
    LcdInitialized = RESET;
  }

  /* Disable remaining clocks */
  __HAL_RCC_PWR_CLK_DISABLE();
  __HAL_RCC_FLASH_CLK_DISABLE();
  __HAL_RCC_SYSCFG_CLK_DISABLE();
  __HAL_RCC_GPIOA_CLK_DISABLE();
  __HAL_RCC_GPIOB_CLK_DISABLE();
  __HAL_RCC_GPIOC_CLK_DISABLE();
  __HAL_RCC_GPIOD_CLK_DISABLE();
  __HAL_RCC_GPIOE_CLK_DISABLE();
  __HAL_RCC_I2C2_CLK_DISABLE();
  RCC->AHB1SMENR = 0x0;
  RCC->AHB2SMENR = 0x0;
  RCC->AHB3SMENR = 0x0;
  RCC->APB1SMENR1 = 0x0;
  RCC->APB1SMENR2 = 0x0;
  RCC->APB2SMENR = 0x0;
  }

static void Display_DemoDescription(void)
{
  /* Clear the LCD */ 
  BSP_LCD_GLASS_Clear();

  /* Display LCD messages */
  BSP_LCD_GLASS_ScrollSentence((uint8_t *)"     STM32L476G-DISCO BSP DRIVER EXAMPLE", 1, SCROLL_SPEED_HIGH);
  BSP_LCD_GLASS_ScrollSentence((uint8_t *)"     COPYRIGHT STMICROELECTRONICS 2015", 1, SCROLL_SPEED_HIGH);

  /* Introduce short delay before new message displayed */
  HAL_Delay(50);

  BSP_LCD_GLASS_ScrollSentence((uint8_t *)"      Press Joy Right to start ", 0xFFFF, SCROLL_SPEED_HIGH);

  /* Clear the LCD & reset Key pressed variable */
  BSP_LCD_GLASS_Clear();

  AppStatus = DEMO_STATE_IDLE;
}

uint8_t CheckForUserInput(void)
{
  if(BSP_JOY_GetState() == JOY_SEL)
  {
    while (BSP_JOY_GetState() == JOY_SEL);
    return 1;
  }
  return 0;
}

/**lerais 
  * @brief  This function is executed in case of error occurrence.
  * @param  None
  * @retval None
  */
void Error_Handler(void)
{
  /* Turn LED RED on */
  while(1)
  {
    BSP_LED_Toggle(LED_RED);
    HAL_Delay(40);
  }
}


void HAL_GPIO_EXTI_Callback(uint16_t GPIO_Pin)
{
  if((GPIO_Pin & (DOWN_JOY_PIN | UP_JOY_PIN | SEL_JOY_PIN | RIGHT_JOY_PIN | LEFT_JOY_PIN))
      != RESET)
  {
    KeyPressed = SET;
    
    switch(AppStatus)
    {
      case DEMO_STATE_FIRST_STARTUP:
      
      
      case DEMO_STATE_IDLE:
        bLCDGlass_KeyPressed = 0x01;
        switch(GPIO_Pin)
        {
          case DOWN_JOY_PIN :
            DemoIndex++;
            if(DemoIndex > COUNT_OF_EXAMPLE(BSP_examples))
            {
             DemoIndex = 0;
            }
            break;
          case UP_JOY_PIN :
            DemoIndex--;
            if(DemoIndex > COUNT_OF_EXAMPLE(BSP_examples))
            {
             DemoIndex = (COUNT_OF_EXAMPLE(BSP_examples) - 1);
            }
            break;
          case RIGHT_JOY_PIN :
            AppLaunched = SET;
            break;
        }
        break;
    
      case DEMO_STATE_LED:
        break;
      
      case DEMO_STATE_JOYSTICK:
      case DEMO_STATE_LCD:
        switch(GPIO_Pin)
        {
          case DOWN_JOY_PIN :
            JoyState = JOY_DOWN;
            break;
          case UP_JOY_PIN :
            JoyState = JOY_UP;
            break;
          case SEL_JOY_PIN :
            JoyState = JOY_SEL;
            break;
          case RIGHT_JOY_PIN :
            JoyState = JOY_RIGHT;
            break;
          case LEFT_JOY_PIN :
            JoyState = JOY_LEFT;
            break;
        }
        break;
        
      
    case DEMO_STATE_AUDIO_RECORD:
        switch(GPIO_Pin)
        {
          case RIGHT_JOY_PIN :
            /* SEL is used to confirm audio record sample rate and start audio recording */
            AudioRecordSampleRateSelected = 1;
            break;
        }
      break;
    }
  }
}