/**
******************************************************************************
* @file    main.c 
* @author  Central Labs
* @version V1.0.0
* @date    7-May-2015
* @brief   Main program body
******************************************************************************
* @attention
*
* <h2><center>&copy; COPYRIGHT(c) 2014 STMicroelectronics</center></h2>
*
* Licensed under MCD-ST Liberty SW License Agreement V2, (the "License");
* You may not use this file except in compliance with the License.
* You may obtain a copy of the License at:
*
*        http://www.st.com/software_license_agreement_liberty_v2
*
* Redistribution and use in source and binary forms, with or without modification,
* are permitted provided that the following conditions are met:
*   1. Redistributions of source code must retain the above copyright notice,
*      this list of conditions and the following disclaimer.
*   2. Redistributions in binary form must reproduce the above copyright notice,
*      this list of conditions and the following disclaimer in the documentation
*      and/or other materials provided with the distribution.
*   3. Neither the name of STMicroelectronics nor the names of its contributors
*      may be used to endorse or promote products derived from this software
*      without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
******************************************************************************
*/


/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
#include "stm32l4xx_hal_def.h"
#include "stm32l4xx_hal_conf.h"
#include "main.h"


Serial pc(SERIAL_TX, SERIAL_RX);
DigitalIn mybutton(PA_0);
DigitalOut myled(LED1);
//SDFileSystem sd(PC_12, PC_11, PC_10, PD_2, "sd");

/**
* @brief  Main program
* @param  None
* @retval None
*/
extern void RECORD(void);
extern void MSE(void);
extern void COMPARE(void);

extern  float32_t CONTROLPWR[1024]; //CONTROL 0 PWR
extern  float32_t CONTROLPHS[1024]; //CTONROL 0 PHS
extern  float32_t CONTROLPWRMSE;//CONTROL PWR MSE
extern  float32_t CONTROLPHSMSE;//CONTROL PHS MSE
extern float32_t POWER[1024];
extern float32_t PHS[1024];
extern float32_t PWRMSE;
extern float32_t PHSMSE;

int main(void)
{
	
	pc.printf("\r\n\r\nEntering AudioRecord_demo()...\r\n");
	RECORD();	// RECORD CONTROL 0
	uint32_t n;
	for(n=0;n<1024;n++)
	{CONTROLPWR[n]=POWER[n];}
	for(n=0;n<1024;n++)
	{CONTROLPHS[n]=PHS[n];}
	RECORD(); //RECORD CONTROL 1
	MSE(); //MSE BETWEEN CONTROLS
	CONTROLPWRMSE=PWRMSE;
	CONTROLPHSMSE=PHSMSE;
	while (1) {
		pc.printf("Prepared to begin recording. Click USER button to continue...\r\n");
		while (mybutton);
		wait(0.2);
		if (!mybutton) {
			while (!mybutton);
			pc.printf("Recording started...\r\n");
			myled = 1;
			RECORD();
			MSE();
			COMPARE();
		}
	}
}


#ifdef  USE_FULL_ASSERT

/**
* @brief  Reports the name of the source file and the source line number
*         where the assert_param error has occurred.
* @param  file: pointer to the source file name
* @param  line: assert_param error line source number
* @retval None
*/
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
  ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  
  /* Infinite loop */
  while (1)
  {
  }
}
#endif


/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/

