#include "main.h" //FROM DFSDM CORE
#include <math.h>
#include "stdio.h"
#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "arm_math.h" 
#include "SDFileSystem.h"
//#include "main.h"
#define samplenum 1024
//FROM DFSDM CORE
extern void RECORD(void);
extern void MSE(void);
extern void COMPARE(void);

extern  float32_t CONTROLPWR[1024]; //CONTROL 0 PWR
extern  float32_t CONTROLPHS[1024]; //CTONROL 0 PHS
extern  float32_t CONTROLPWRMSE;//CONTROL PWR MSE
extern  float32_t CONTROLPHSMSE;//CONTROL PHS MSE
extern float32_t POWER[1024];
extern float32_t PHS[1024];
extern float32_t PWRMSE;
extern float32_t PHSMSE;

Serial pc(SERIAL_TX, SERIAL_RX);
//DigitalIn mybutton(USER_BUTTON);
//DigitalOut myled(LED1);
//SDFileSystem sd(PC_12, PC_11, PC_10, PD_2, "sd");
//
 
DigitalIn ain1(PC_9);
DigitalIn ain2(PB_15);
DigitalIn ain3(PC_7);
DigitalIn ain4(PC_6);
DigitalIn ain5(PC_8);
 
uint32_t ifftFlag = 0; 
uint32_t doBitReverse = 1; 
     
/* Reference index at which max energy of bin ocuurs */ 
uint32_t refIndex = 213, testIndex = 0; 

const float32_t a[samplenum] = {  -0.865129623056441,      -2.655020678073846,      0.600664612949661,      0.080378093886515,       -2.899160484012034,      2.563004262857762,      3.078328403304206,      0.505906778385130,                            0.048366940168201,      -0.545696461188734,      -0.023417155362879,      2.127729174988954,       -1.176633086028377,      3.690223557991855,      -0.622791766173194,      0.722837373872203,                            2.739754205367484,      -0.062610410524552,      -0.891296810967338,      -1.845872258871811,       1.195039415434387,      -2.177388969045026,      1.078649103637905,      2.570976050490193,                            -1.383551403404574,      2.392141424058873,      2.858002843205065,      -3.682433899725536,       -3.488146646451150,      1.323468578888120,      -0.099771155430726,      1.561168082500454,
                            1.025026795103179,      0.928841900171200,      2.930499509864950,      2.013349089766430,       2.381676148486737,      -3.081062307950236,      -0.389579115537544,      0.581540149166620,                            -2.601953341353208,      0.333435137781238,      -2.812945856162965,      2.649109640172910,       -1.003963025744654,      1.552460768755035,      0.088641345335247,      -2.519951327113426,                            -4.341348988610527,      0.557772429359965,      -1.671267412948494,      0.733951350960387,       0.409263788034864,      3.566033071952806,      1.882565173848352,      -1.106017073793287,                            0.554456720778718,      -2.513205795512153,      0.310978660939421,      0.579706500111723,       0.000086383683251,      -1.311866980897721,      1.840007477574986,      -3.253005768451345,
                            1.462584328739432,      1.610103610851738,      0.761914676858907,      0.974541361089834,       0.686845845885983,      1.849153122025191,      0.787800410401453,      -1.187438909666279,                            -0.754937911044720,      0.084373858395232,      -2.600269011710521,      -0.962982842142644,       -0.369328108540868,      0.810791418361879,      3.587016488699641,      -0.520776145083723,                            0.640249919627884,      1.103122489464969,      2.231779881455556,      -1.308035392685241,       0.424070304330106,      -0.200383932651189,      -2.365526783356541,      -0.989114757436628,                            2.770807688959777,      -0.444172737462307,      0.079760979374078,      -0.005199118412183,       -0.664712668309527,      -0.624171857561896,      0.537306979007338,      -2.575955675497642,
                            1.562363235756780,      1.814069369848895,      -1.293428583392509,      -1.026188449495686,       -2.981771815588717,      -4.223468103075124,      2.672674782004045,      -0.856096801117735,                            0.048517345512563,      -0.026860721136225,      0.392932277758187,      -1.331740855093099,       -1.894292129477081,      -1.425006468460681,      -2.721772427617057,      -1.616831100216806,                            3.551177651488947,      -0.069685667896087,      -3.134634907409102,      -0.263627598944639,       -1.650469945991350,      -2.203580339374399,      -0.872203246123242,      1.230782812607287,                            0.257288860093291,      1.989083106173137,      -1.985638729453261,      -1.416385105842892,       -1.131097688325772,      -2.245130805416057,      -1.938873996219074,      2.043608361562645,
                            -0.865129623056441,      -2.655020678073846,      0.600664612949661,      0.080378093886515,       -2.899160484012034,      2.563004262857762,      3.078328403304206,      0.505906778385130,                            0.048366940168201,      -0.545696461188734,      -0.023417155362879,      2.127729174988954,       -1.176633086028377,      3.690223557991855,      -0.622791766173194,      0.722837373872203,                            2.739754205367484,      -0.062610410524552,      -0.891296810967338,      -1.845872258871811,       1.195039415434387,      -2.177388969045026,      1.078649103637905,      2.570976050490193,                            -1.383551403404574,      2.392141424058873,      2.858002843205065,      -3.682433899725536,       -3.488146646451150,      1.323468578888120,      -0.099771155430726,      1.561168082500454,
                            1.025026795103179,      0.928841900171200,      2.930499509864950,      2.013349089766430,       2.381676148486737,      -3.081062307950236,      -0.389579115537544,      0.581540149166620,                            -2.601953341353208,      0.333435137781238,      -2.812945856162965,      2.649109640172910,       -1.003963025744654,      1.552460768755035,      0.088641345335247,      -2.519951327113426,                            -4.341348988610527,      0.557772429359965,      -1.671267412948494,      0.733951350960387,       0.409263788034864,      3.566033071952806,      1.882565173848352,      -1.106017073793287,                            0.554456720778718,      -2.513205795512153,      0.310978660939421,      0.579706500111723,       0.000086383683251,      -1.311866980897721,      1.840007477574986,      -3.253005768451345,
                            1.462584328739432,      1.610103610851738,      0.761914676858907,      0.974541361089834,       0.686845845885983,      1.849153122025191,      0.787800410401453,      -1.187438909666279,                            -0.754937911044720,      0.084373858395232,      -2.600269011710521,      -0.962982842142644,       -0.369328108540868,      0.810791418361879,      3.587016488699641,      -0.520776145083723,                            0.640249919627884,      1.103122489464969,      2.231779881455556,      -1.308035392685241,       0.424070304330106,      -0.200383932651189,      -2.365526783356541,      -0.989114757436628,                            2.770807688959777,      -0.444172737462307,      0.079760979374078,      -0.005199118412183,       -0.664712668309527,      -0.624171857561896,      0.537306979007338,      -2.575955675497642,
                            1.562363235756780,      1.814069369848895,      -1.293428583392509,      -1.026188449495686,       -2.981771815588717,      -4.223468103075124,      2.672674782004045,      -0.856096801117735,                            0.048517345512563,      -0.026860721136225,      0.392932277758187,      -1.331740855093099,       -1.894292129477081,      -1.425006468460681,      -2.721772427617057,      -1.616831100216806,                            3.551177651488947,      -0.069685667896087,      -3.134634907409102,      -0.263627598944639,       -1.650469945991350,      -2.203580339374399,      -0.872203246123242,      1.230782812607287,                            0.257288860093291,      1.989083106173137,      -1.985638729453261,      -1.416385105842892,       -1.131097688325772,      -2.245130805416057,      -1.938873996219074,      2.043608361562645,
                            -0.865129623056441,      -2.655020678073846,      0.600664612949661,      0.080378093886515,       -2.899160484012034,      2.563004262857762,      3.078328403304206,      0.505906778385130,                            0.048366940168201,      -0.545696461188734,      -0.023417155362879,      2.127729174988954,       -1.176633086028377,      3.690223557991855,      -0.622791766173194,      0.722837373872203,                            2.739754205367484,      -0.062610410524552,      -0.891296810967338,      -1.845872258871811,       1.195039415434387,      -2.177388969045026,      1.078649103637905,      2.570976050490193,                            -1.383551403404574,      2.392141424058873,      2.858002843205065,      -3.682433899725536,       -3.488146646451150,      1.323468578888120,      -0.099771155430726,      1.561168082500454,
                            1.025026795103179,      0.928841900171200,      2.930499509864950,      2.013349089766430,       2.381676148486737,      -3.081062307950236,      -0.389579115537544,      0.581540149166620,                            -2.601953341353208,      0.333435137781238,      -2.812945856162965,      2.649109640172910,       -1.003963025744654,      1.552460768755035,      0.088641345335247,      -2.519951327113426,                            -4.341348988610527,      0.557772429359965,      -1.671267412948494,      0.733951350960387,       0.409263788034864,      3.566033071952806,      1.882565173848352,      -1.106017073793287,                            0.554456720778718,      -2.513205795512153,      0.310978660939421,      0.579706500111723,       0.000086383683251,      -1.311866980897721,      1.840007477574986,      -3.253005768451345,
                            1.462584328739432,      1.610103610851738,      0.761914676858907,      0.974541361089834,       0.686845845885983,      1.849153122025191,      0.787800410401453,      -1.187438909666279,                            -0.754937911044720,      0.084373858395232,      -2.600269011710521,      -0.962982842142644,       -0.369328108540868,      0.810791418361879,      3.587016488699641,      -0.520776145083723,                            0.640249919627884,      1.103122489464969,      2.231779881455556,      -1.308035392685241,       0.424070304330106,      -0.200383932651189,      -2.365526783356541,      -0.989114757436628,                            2.770807688959777,      -0.444172737462307,      0.079760979374078,      -0.005199118412183,       -0.664712668309527,      -0.624171857561896,      0.537306979007338,      -2.575955675497642,
                            1.562363235756780,      1.814069369848895,      -1.293428583392509,      -1.026188449495686,       -2.981771815588717,      -4.223468103075124,      2.672674782004045,      -0.856096801117735,                            0.048517345512563,      -0.026860721136225,      0.392932277758187,      -1.331740855093099,       -1.894292129477081,      -1.425006468460681,      -2.721772427617057,      -1.616831100216806,                            3.551177651488947,      -0.069685667896087,      -3.134634907409102,      -0.263627598944639,       -1.650469945991350,      -2.203580339374399,      -0.872203246123242,      1.230782812607287,                            0.257288860093291,      1.989083106173137,      -1.985638729453261,      -1.416385105842892,       -1.131097688325772,      -2.245130805416057,      -1.938873996219074,      2.043608361562645,
                            -0.865129623056441,      -2.655020678073846,      0.600664612949661,      0.080378093886515,       -2.899160484012034,      2.563004262857762,      3.078328403304206,      0.505906778385130,                            0.048366940168201,      -0.545696461188734,      -0.023417155362879,      2.127729174988954,       -1.176633086028377,      3.690223557991855,      -0.622791766173194,      0.722837373872203,                            2.739754205367484,      -0.062610410524552,      -0.891296810967338,      -1.845872258871811,       1.195039415434387,      -2.177388969045026,      1.078649103637905,      2.570976050490193,                            -1.383551403404574,      2.392141424058873,      2.858002843205065,      -3.682433899725536,       -3.488146646451150,      1.323468578888120,      -0.099771155430726,      1.561168082500454,
                            1.025026795103179,      0.928841900171200,      2.930499509864950,      2.013349089766430,       2.381676148486737,      -3.081062307950236,      -0.389579115537544,      0.581540149166620,                            -2.601953341353208,      0.333435137781238,      -2.812945856162965,      2.649109640172910,       -1.003963025744654,      1.552460768755035,      0.088641345335247,      -2.519951327113426,                            -4.341348988610527,      0.557772429359965,      -1.671267412948494,      0.733951350960387,       0.409263788034864,      3.566033071952806,      1.882565173848352,      -1.106017073793287,                            0.554456720778718,      -2.513205795512153,      0.310978660939421,      0.579706500111723,       0.000086383683251,      -1.311866980897721,      1.840007477574986,      -3.253005768451345,
                            1.462584328739432,      1.610103610851738,      0.761914676858907,      0.974541361089834,       0.686845845885983,      1.849153122025191,      0.787800410401453,      -1.187438909666279,                            -0.754937911044720,      0.084373858395232,      -2.600269011710521,      -0.962982842142644,       -0.369328108540868,      0.810791418361879,      3.587016488699641,      -0.520776145083723,                            0.640249919627884,      1.103122489464969,      2.231779881455556,      -1.308035392685241,       0.424070304330106,      -0.200383932651189,      -2.365526783356541,      -0.989114757436628,                            2.770807688959777,      -0.444172737462307,      0.079760979374078,      -0.005199118412183,       -0.664712668309527,      -0.624171857561896,      0.537306979007338,      -2.575955675497642,
                            1.562363235756780,      1.814069369848895,      -1.293428583392509,      -1.026188449495686,       -2.981771815588717,      -4.223468103075124,      2.672674782004045,      -0.856096801117735,                            0.048517345512563,      -0.026860721136225,      0.392932277758187,      -1.331740855093099,       -1.894292129477081,      -1.425006468460681,      -2.721772427617057,      -1.616831100216806,                            3.551177651488947,      -0.069685667896087,      -3.134634907409102,      -0.263627598944639,       -1.650469945991350,      -2.203580339374399,      -0.872203246123242,      1.230782812607287,                            0.257288860093291,      1.989083106173137,      -1.985638729453261,      -1.416385105842892,       -1.131097688325772,      -2.245130805416057,      -1.938873996219074,      2.043608361562645,
                            -0.865129623056441,      -2.655020678073846,      0.600664612949661,      0.080378093886515,       -2.899160484012034,      2.563004262857762,      3.078328403304206,      0.505906778385130,                            0.048366940168201,      -0.545696461188734,      -0.023417155362879,      2.127729174988954,       -1.176633086028377,      3.690223557991855,      -0.622791766173194,      0.722837373872203,                            2.739754205367484,      -0.062610410524552,      -0.891296810967338,      -1.845872258871811,       1.195039415434387,      -2.177388969045026,      1.078649103637905,      2.570976050490193,                            -1.383551403404574,      2.392141424058873,      2.858002843205065,      -3.682433899725536,       -3.488146646451150,      1.323468578888120,      -0.099771155430726,      1.561168082500454,
                            1.025026795103179,      0.928841900171200,      2.930499509864950,      2.013349089766430,       2.381676148486737,      -3.081062307950236,      -0.389579115537544,      0.581540149166620,                            -2.601953341353208,      0.333435137781238,      -2.812945856162965,      2.649109640172910,       -1.003963025744654,      1.552460768755035,      0.088641345335247,      -2.519951327113426,                            -4.341348988610527,      0.557772429359965,      -1.671267412948494,      0.733951350960387,       0.409263788034864,      3.566033071952806,      1.882565173848352,      -1.106017073793287,                           0.554456720778718,      -2.513205795512153,      0.310978660939421,      0.579706500111723,       0.000086383683251,      -1.311866980897721,      1.840007477574986,      -3.253005768451345,
                            1.462584328739432,      1.610103610851738,      0.761914676858907,      0.974541361089834,       0.686845845885983,      1.849153122025191,      0.787800410401453,      -1.187438909666279,                            -0.754937911044720,      0.084373858395232,      -2.600269011710521,      -0.962982842142644,       -0.369328108540868,      0.810791418361879,      3.587016488699641,      -0.520776145083723,                            0.640249919627884,      1.103122489464969,      2.231779881455556,      -1.308035392685241,       0.424070304330106,      -0.200383932651189,      -2.365526783356541,      -0.989114757436628,                            2.770807688959777,      -0.444172737462307,      0.079760979374078,      -0.005199118412183,       -0.664712668309527,      -0.624171857561896,      0.537306979007338,      -2.575955675497642,
                            1.562363235756780,      1.814069369848895,      -1.293428583392509,      -1.026188449495686,       -2.981771815588717,      -4.223468103075124,      2.672674782004045,      -0.856096801117735,                            0.048517345512563,      -0.026860721136225,      0.392932277758187,      -1.331740855093099,       -1.894292129477081,      -1.425006468460681,      -2.721772427617057,      -1.616831100216806,                            3.551177651488947,      -0.069685667896087,      -3.134634907409102,      -0.263627598944639,       -1.650469945991350,      -2.203580339374399,      -0.872203246123242,      1.230782812607287,                            0.257288860093291,      1.989083106173137,      -1.985638729453261,      -1.416385105842892,       -1.131097688325772,      -2.245130805416057,      -1.938873996219074,      2.043608361562645,
                            -0.865129623056441,      -2.655020678073846,      0.600664612949661,      0.080378093886515,       -2.899160484012034,      2.563004262857762,      3.078328403304206,      0.505906778385130,                            0.048366940168201,      -0.545696461188734,      -0.023417155362879,      2.127729174988954,       -1.176633086028377,      3.690223557991855,      -0.622791766173194,      0.722837373872203,                           2.739754205367484,      -0.062610410524552,      -0.891296810967338,      -1.845872258871811,       1.195039415434387,      -2.177388969045026,      1.078649103637905,      2.570976050490193,                            -1.383551403404574,      2.392141424058873,      2.858002843205065,      -3.682433899725536,       -3.488146646451150,      1.323468578888120,      -0.099771155430726,      1.561168082500454,
                            1.025026795103179,      0.928841900171200,      2.930499509864950,      2.013349089766430,       2.381676148486737,      -3.081062307950236,      -0.389579115537544,      0.581540149166620,                            -2.601953341353208,      0.333435137781238,      -2.812945856162965,      2.649109640172910,       -1.003963025744654,      1.552460768755035,      0.088641345335247,      -2.519951327113426,                            -4.341348988610527,      0.557772429359965,      -1.671267412948494,      0.733951350960387,       0.409263788034864,      3.566033071952806,      1.882565173848352,      -1.106017073793287,                            0.554456720778718,      -2.513205795512153,      0.310978660939421,      0.579706500111723,       0.000086383683251,      -1.311866980897721,      1.840007477574986,      -3.253005768451345,
                            1.462584328739432,      1.610103610851738,      0.761914676858907,      0.974541361089834,       0.686845845885983,      1.849153122025191,      0.787800410401453,      -1.187438909666279,                            -0.754937911044720,      0.084373858395232,      -2.600269011710521,      -0.962982842142644,       -0.369328108540868,      0.810791418361879,      3.587016488699641,      -0.520776145083723,                            0.640249919627884,      1.103122489464969,      2.231779881455556,      -1.308035392685241,       0.424070304330106,      -0.200383932651189,      -2.365526783356541,      -0.989114757436628,                            2.770807688959777,      -0.444172737462307,      0.079760979374078,      -0.005199118412183,       -0.664712668309527,      -0.624171857561896,      0.537306979007338,      -2.575955675497642,
                            1.562363235756780,      1.814069369848895,      -1.293428583392509,      -1.026188449495686,       -2.981771815588717,      -4.223468103075124,      2.672674782004045,      -0.856096801117735,                            0.048517345512563,      -0.026860721136225,      0.392932277758187,      -1.331740855093099,       -1.894292129477081,      -1.425006468460681,      -2.721772427617057,      -1.616831100216806,                            3.551177651488947,      -0.069685667896087,      -3.134634907409102,      -0.263627598944639,       -1.650469945991350,      -2.203580339374399,      -0.872203246123242,      1.230782812607287,                            0.257288860093291,      1.989083106173137,      -1.985638729453261,      -1.416385105842892,       -1.131097688325772,      -2.245130805416057,      -1.938873996219074,      2.043608361562645,
                            -0.865129623056441,      -2.655020678073846,      0.600664612949661,      0.080378093886515,       -2.899160484012034,      2.563004262857762,      3.078328403304206,      0.505906778385130,                            0.048366940168201,      -0.545696461188734,      -0.023417155362879,      2.127729174988954,       -1.176633086028377,      3.690223557991855,      -0.622791766173194,      0.722837373872203,                            2.739754205367484,      -0.062610410524552,      -0.891296810967338,      -1.845872258871811,       1.195039415434387,      -2.177388969045026,      1.078649103637905,      2.570976050490193,                            -1.383551403404574,      2.392141424058873,      2.858002843205065,      -3.682433899725536,       -3.488146646451150,      1.323468578888120,      -0.099771155430726,      1.561168082500454,
                            1.025026795103179,      0.928841900171200,      2.930499509864950,      2.013349089766430,       2.381676148486737,      -3.081062307950236,      -0.389579115537544,      0.581540149166620,                            -2.601953341353208,      0.333435137781238,      -2.812945856162965,      2.649109640172910,       -1.003963025744654,      1.552460768755035,      0.088641345335247,      -2.519951327113426,                            -4.341348988610527,      0.557772429359965,      -1.671267412948494,      0.733951350960387,       0.409263788034864,      3.566033071952806,      1.882565173848352,      -1.106017073793287,                            0.554456720778718,      -2.513205795512153,      0.310978660939421,      0.579706500111723,       0.000086383683251,      -1.311866980897721,      1.840007477574986,      -3.253005768451345,
                            1.462584328739432,      1.610103610851738,      0.761914676858907,      0.974541361089834,       0.686845845885983,      1.849153122025191,      0.787800410401453,      -1.187438909666279,                            -0.754937911044720,      0.084373858395232,      -2.600269011710521,      -0.962982842142644,       -0.369328108540868,      0.810791418361879,      3.587016488699641,      -0.520776145083723,                            0.640249919627884,      1.103122489464969,      2.231779881455556,      -1.308035392685241,       0.424070304330106,      -0.200383932651189,      -2.365526783356541,      -0.989114757436628,                            2.770807688959777,      -0.444172737462307,      0.079760979374078,      -0.005199118412183,       -0.664712668309527,      -0.624171857561896,      0.537306979007338,      -2.575955675497642,
                            1.562363235756780,      1.814069369848895,      -1.293428583392509,      -1.026188449495686,       -2.981771815588717,      -4.223468103075124,      2.672674782004045,      -0.856096801117735,                            0.048517345512563,      -0.026860721136225,      0.392932277758187,      -1.331740855093099,       -1.894292129477081,      -1.425006468460681,      -2.721772427617057,      -1.616831100216806,                            3.551177651488947,      -0.069685667896087,      -3.134634907409102,      -0.263627598944639,       -1.650469945991350,      -2.203580339374399,      -0.872203246123242,      1.230782812607287,                            0.257288860093291,      1.989083106173137,      -1.985638729453261,      -1.416385105842892,       -1.131097688325772,      -2.245130805416057,      -1.938873996219074,      2.043608361562645,
                            -0.865129623056441,      -2.655020678073846,      0.600664612949661,      0.080378093886515,       -2.899160484012034,      2.563004262857762,      3.078328403304206,      0.505906778385130,                            0.048366940168201,      -0.545696461188734,      -0.023417155362879,      2.127729174988954,       -1.176633086028377,      3.690223557991855,      -0.622791766173194,      0.722837373872203,                            2.739754205367484,      -0.062610410524552,      -0.891296810967338,      -1.845872258871811,       1.195039415434387,      -2.177388969045026,      1.078649103637905,      2.570976050490193,                            -1.383551403404574,      2.392141424058873,      2.858002843205065,      -3.682433899725536,       -3.488146646451150,      1.323468578888120,      -0.099771155430726,      1.561168082500454,
                            1.025026795103179,      0.928841900171200,      2.930499509864950,      2.013349089766430,       2.381676148486737,      -3.081062307950236,      -0.389579115537544,      0.581540149166620,                            -2.601953341353208,      0.333435137781238,      -2.812945856162965,      2.649109640172910,       -1.003963025744654,      1.552460768755035,      0.088641345335247,      -2.519951327113426,                            -4.341348988610527,      0.557772429359965,      -1.671267412948494,      0.733951350960387,       0.409263788034864,      3.566033071952806,      1.882565173848352,      -1.106017073793287,                            0.554456720778718,      -2.513205795512153,      0.310978660939421,      0.579706500111723,       0.000086383683251,      -1.311866980897721,      1.840007477574986,      -3.253005768451345,
                            1.462584328739432,      1.610103610851738,      0.761914676858907,      0.974541361089834,       0.686845845885983,      1.849153122025191,      0.787800410401453,      -1.187438909666279,                            -0.754937911044720,      0.084373858395232,      -2.600269011710521,      -0.962982842142644,       -0.369328108540868,      0.810791418361879,      3.587016488699641,      -0.520776145083723,                            0.640249919627884,      1.103122489464969,      2.231779881455556,      -1.308035392685241,       0.424070304330106,      -0.200383932651189,      -2.365526783356541,      -0.989114757436628,                            2.770807688959777,      -0.444172737462307,      0.079760979374078,      -0.005199118412183,       -0.664712668309527,      -0.624171857561896,      0.537306979007338,      -2.575955675497642,                            1.562363235756780,      1.814069369848895,      -1.293428583392509,      -1.026188449495686,       -2.981771815588717,      -4.223468103075124,      2.672674782004045,      -0.856096801117735,                            0.048517345512563,      -0.026860721136225,      0.392932277758187,      -1.331740855093099,       -1.894292129477081,      -1.425006468460681,      -2.721772427617057,      -1.616831100216806,                            3.551177651488947,      -0.069685667896087,      -3.134634907409102,      -0.263627598944639,       -1.650469945991350,      -2.203580339374399,      -0.872203246123242,      1.230782812607287,                            0.257288860093291,      1.989083106173137,      -1.985638729453261,      -1.416385105842892,       -1.131097688325772,      -2.245130805416057,      -1.938873996219074,      2.043608361562645,
          };
const float32_t b[samplenum] = {   };
float32_t  a1, b1;
float32_t  SubOutMSE, SquareOutMSE, SubOutST, SquareOutST;
int h=0;                                         // 321    h = hr, m = min, for interval
int m=0;
int i=h;
int j=m;
 
//SPI_TFT_ILI9341 TFT(D11, D12, D13, D10, D8, D9, "TFT"); // mosi, miso, sclk, cs, reset, dc
SPI_TFT_ILI9341 TFT(PC_3, PC_2, PB_10, PB_12, PA_8, PA_11, "TFT"); // mosi, miso, sclk, cs, reset, dc
SDFileSystem sd(PB_5, PB_4, PB_3, PA_10, "sd"); // mosi, miso, sclk, cs

DigitalOut skywire_en(PA_6);
//DigitalOut skywire_rts(PA_7);
Serial skywire(PA_0,PA_1);

volatile int rx_in=0;
volatile int rx_out=0;
const int buffer_size = 255;
char rx_buffer[buffer_size+1];
char rx_line[buffer_size];

void read_line()
{
    int i;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    __disable_irq();
// Loop reading rx buffer characters until end of line character
    while ((i==0) || ((rx_line[i-1] != '\r') && (rx_line[i-1] != '\n'))) {
// Wait if buffer empty
        if (rx_in == rx_out) {
// End Critical Section - need to allow rx interrupt to get new characters for buffer
            __enable_irq();
            while (rx_in == rx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            __disable_irq();
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }
// End Critical Section
    __enable_irq();
    rx_line[i-1] = 0;
    return;
}

int WaitForResponse(char* response)
{
    do {
        do {
            read_line();
        } while ((unsigned char)rx_line[0] <= 32);
//        debug_pc.printf("Waiting for: %s, Received: %s\r\n", response, rx_line);
    } while (strncmp(rx_line, response, strlen(response)));
    return 0;
}

void Skywire_Rx_interrupt()
{
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((skywire.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = skywire.getc();
        rx_in = (rx_in + 1) % buffer_size;
    }
    return;
}

int main()
{  
    int stage=0;
    int menu=0;
    int config=0;
    int set=0;
    int comp=0;
    float32_t stmean=0;
    float32_t stmse=0;
    float32_t stst=0;
    char log[10][32];
    float32_t mselog[10] = {NULL};
//    set_time(1448935737);           // Set RTC time to Dec 01 2015 02:09 AM
    int pu, pd, ps;                 // LL left & right
    TFT.claim(stdout);              // send stdout to the TFT display
    TFT.claim(stderr);              // send stderr to the TFT display
    TFT.set_orientation(2); 
    TFT.background(Black);          // set background to black
    TFT.foreground(White);          // set chars to white
    TFT.cls();                      // clear the screen
    
    
    while(1)
    {    
        if (stage==0) { //menu
            TFT.set_font((unsigned char*) Arial24x23);
            TFT.locate(19,60);
            TFT.foreground(White);
            printf("Configuration");
            TFT.locate(50,110);
            TFT.printf("Waveform");
            TFT.locate(95,160);
            TFT.printf("Log");
//            wait_LowPow(3);               // Wait 3s in low power mode,   seems just hold display
            if (set==0) {
                TFT.locate(70,260);
                TFT.foreground(DarkGrey);
                printf("START");
            }
            if (set==1) {
                TFT.locate(70,260);
                TFT.foreground(White);
                printf("START");
                TFT.set_font((unsigned char*) Arial12x12);
                TFT.locate(30, 240);
                printf("interval:  %i hr  %i min", h, m);
            }
 
            if (menu==0) {  //Configuration
                TFT.rect(13,55,225,85,Green);
                TFT.rect(13,105,225,135,Black);
                pu = ain1.read();
                pd = ain2.read();
                ps = ain3.read();
                if (pd==1)  {   wait(0.3);  menu=1; }
                if (ps==1)  {   wait(0.3);  TFT.cls();  stage=1;    }
            }
 
            if (menu==1) {  //waveform
                TFT.rect(13,55,225,85,Black);
                TFT.rect(13,105,225,135,Green);
                TFT.rect(13,155,225,185,Black);
                pu = ain1.read();
                pd = ain2.read();
                ps = ain3.read();
                if (pu==1)  {   wait(0.3);  menu=0; }
                if (pd==1)  {   wait(0.3);  menu=2; }
                if (ps==1)  {   wait(0.3);  TFT.cls();  stage=2;    }
            }
 
            if (menu==2) {  //log
                TFT.rect(13,105,225,135,Black);
                TFT.rect(13,155,225,185,Green);
                TFT.rect(13,255,225,285,Black);
                pu = ain1.read();
                pd = ain2.read();
                ps = ain3.read();
                if (pu==1)  {   wait(0.3);  menu=1; }
                if ((pd==1)&&(set==1))  {   wait(0.3);  menu=3; }
                if (ps==1)  {   wait(0.3);  TFT.cls();  stage=3;    }
            }
 
            if (menu==3) {  //START
                TFT.rect(13,155,225,185,Black);
                TFT.rect(13,255,225,285,Green);
                pu = ain1.read();
                pd = ain2.read();
                ps = ain3.read();
                if (pu==1)  {   wait(0.3);  menu=2; }
                if (ps==1)  {   wait(0.3);  TFT.cls();  stage=5;    }
            }
        }
        
        if (stage==1) { //Configuration
            int ia, ib, ja, jb;
 
            TFT.set_font((unsigned char*) Arial24x23);
            TFT.locate(20,55);
            TFT.foreground(White);
            printf("SET PERIOD");
            TFT.rect(15,50, 220,80,Red);
            TFT.locate(70,120);
            TFT.printf("Hr    Min");
            TFT.locate(10,200);
            printf("Record Control");
            TFT.set_font((unsigned char*) Arial12x12);
            if (comp==1) {
                TFT.locate(50,233);
                printf("comparison saved");
            }
 
            TFT.set_font((unsigned char*) Arial12x12);
            TFT.locate(40,300);
            printf("Set");
            TFT.locate(165,300);
            printf("Return");
            TFT.rect(22,115, 68,145,Olive);
            TFT.rect(117,115,163,145,Olive);
            TFT.rect(5,195, 230,225,Olive);
            TFT.rect(15,295,85,315,Olive);
            TFT.rect(150,295,220,315,Olive);
 
            while (stage==1) {
                ia=i-1;     if (i==0) ia=23;
                ib=i+1;     if (i==23) ib=0;
                ja=j-1;     if (j==0) ja=59;
                jb=j+1;     if (j==59) jb=00;
 
                TFT.set_font((unsigned char*) Arial24x23);
                TFT.locate(26,120);
                if (i<10)  TFT.printf("0%i", i);
                else if (i>=10)  TFT.printf("%i", i);
                TFT.locate(120,120);
                if (j<10)  TFT.printf("0%i", j);
                else if (j>=10)  TFT.printf("%i", j);
 
                TFT.set_font((unsigned char*) Arial12x12);
                TFT.locate(40,100);
                if (ia<10)  TFT.printf("0%i", ia);
                else if (ia>=10)  TFT.printf("%i", ia);
                TFT.locate(40,150);
                if (ib<10)  TFT.printf("0%i", ib);
                else if (ib>=10)  TFT.printf("%i", ib);
                TFT.locate(135,100);
                if (ja<10)  TFT.printf("0%i", ja);
                else if (ja>=10)  TFT.printf("%i", ja);
                TFT.locate(135,150);
                if (jb<10)  TFT.printf("0%i", jb);
                else if (jb>=10)  TFT.printf("%i", jb);
 
                if  (config==0) {   //hour
                    TFT.rect(22,115, 68,145,Green);
                    TFT.rect(117,115,163,145,Olive);
                    TFT.rect(5,195, 230,225,Olive);
                    pu = ain1.read();
                    pd = ain2.read();
                    ps = ain3.read();
                    if (pu==1)  {   wait(0.3);  i=ib;   }
                    if (pd==1)  {   wait(0.3);  i=ia;   }
                    if (ps==1)  {   wait(0.3);  config=1;   }
                }
                if  (config==1) {   //min
                    TFT.rect(22,115, 68,145,Olive);
                    TFT.rect(117,115,163,145,Green);
                    TFT.rect(5,195, 230,225,Olive);
                    pu = ain1.read();
                    pd = ain2.read();
                    ps = ain3.read();
                    if (pu==1)  {   wait(0.3);  j=jb;   }
                    if (pd==1)  {   wait(0.3);  j=ja;   }
                    if (ps==1)  {   wait(0.3);  config=2;   }
                }
                if  (config==2) {   //Record Control
                    TFT.rect(22,115, 68,145,Olive);
                    TFT.rect(117,115,163,145,Olive);
                    TFT.rect(5,195, 230,225,Green);
                    TFT.rect(15,295,85,315,Olive);
                    TFT.rect(150,295,220,315,Olive);
                    pu = ain1.read();
                    pd = ain2.read();
                    ps = ain3.read();
                    if (pu==1)  {   wait(0.3);  config=0;   }
                    if (pd==1)  {   wait(0.3);  config=3;   }
                    if (ps==1)  {   wait(0.3);  TFT.cls();  stage=4;    }
                }
                if  (config==3) {   //set
                    TFT.rect(5,195, 230,225,Olive);
                    TFT.rect(15,295,85,315,Green);
                    TFT.rect(150,295,220,315,Olive);
                    pu = ain1.read();
                    pd = ain2.read();
                    ps = ain3.read();
                    if (pu==1)  {   wait(0.3);  config=2;   }
                    if (pd==1)  {   wait(0.3);  config=4;   }
                    if (ps==1)  {   wait(0.3);  TFT.cls();
                        if ((i!=0) || (j!=0))
                        {   h=i;    m=j;    set=1;  }
                        stage=0;
                    }
                }
                if  (config==4) {   //return
                    TFT.rect(5,195, 230,225,Olive);
                    TFT.rect(15,295,85,315,Olive);
                    TFT.rect(150,295,220,315,Green);
                    pu = ain1.read();
                    pd = ain2.read();
                    ps = ain3.read();
                    if (pu==1)  {   wait(0.3);  config=3;   }
                    if (pd==1)  {   wait(0.3);  config=4;   }
                    if (ps==1)  {   wait(0.3);  TFT.cls();  stage=0;    }
                }
            }
        }
 
        
        if (stage==2) { //waveform
            int abc, x2, y2;
            int x1 = 0;
            int y1 = 80;
 
            for(abc=0; abc<samplenum; abc=abc+1)            // waveform
            {   a1 = a[abc];
                x2 = abc*2; 
                y2 = 80+a1*10;
                TFT.line(x1,y1,x2,y2,Green);
                x1 = x2;    y1 = y2;
            }
 
            TFT.set_font((unsigned char*) Arial12x12);
            TFT.foreground(White);
            TFT.locate(10,130);
            TFT.printf("Samples number: \n   %i", samplenum);
            TFT.locate(10,160);
            TFT.printf("Sample Mean Value: \n   %f", stmean);
            TFT.locate(10,190);
            TFT.printf("Standard Deviation: \n   %f", stst);
            TFT.locate(10,220);
            TFT.printf("Mean Square Error: \n   %f", stmse);
 
            TFT.locate(165,270);
            printf("Return");
            TFT.rect(150,265,220,285,Green);
            ps = ain3.read();
            if (ps==1)  {   wait(0.3);  TFT.cls();  stage=0;    }
        }
        
        if (stage==3) { //log
            TFT.set_font((unsigned char*) Arial12x12);
            TFT.locate(0,10);
            TFT.foreground(White);
            
            
            //Configure CRC, large frames, and write validation for SD Card
            sd.crc(true);
            sd.large_frames(true);
            sd.write_validation(true);
            
            //Try to mount the SD card
            int row = 50;
            TFT.locate(10,row); TFT.printf("Mounting SD card..."); row+=10; 
            if (sd.mount() != 0) {
                TFT.locate(10,row); TFT.printf("failed!"); row+=10; 
            } else {
            TFT.locate(10,row); TFT.printf("mounted successfully"); row+=10; 
            
                // write event to log
                TFT.locate(10,70);
                FILE *fp = fopen("/sd/event_log.txt", "a");
                if (fp != NULL) {
                    fprintf(fp, "eureka!\r\n");
                    fclose(fp);
                    TFT.locate(10,row); TFT.printf("success"); row+=10; 
                } else {
                    TFT.locate(10,row); TFT.printf("failed to write"); row+=10; 
                }
                sd.unmount();
            }
            
            TFT.locate(10,row); TFT.printf("Configuring Skywire"); row+=10; 
            skywire.baud(115200);
            skywire.attach(&Skywire_Rx_interrupt, Serial::RxIrq);
            
            //Turn off echo
            skywire.printf("ATE0\r\n");
            WaitForResponse("OK");
            TFT.locate(10,row); TFT.printf("Connecting to the Network"); row+=10; 
            // get IP address
            skywire.printf("AT#SGACT=1,1\r\n");         // context activation (returns with IP address)
            WaitForResponse("#SGACT");
            WaitForResponse("OK");
            TFT.locate(10,row); TFT.printf("Connected to the Network"); row+=10; 

/*            float32_t m[6] = {  6.025026,      9.928841,      8.930499,      7.013349,       6.081062,      5.389579};
            int k;
            int l[6] = {    1448934757, 1448935757, 1448935837, 1448938857, 1448940757, 1448945757};
            
            for (k=0; k<6; k++)
            {   set_time(l[k]);
                time_t seconds = time(NULL);
                strftime(log[k], 32, "%b %d %Y  %I:%M %p\n", localtime(&seconds));
                TFT.printf("%s   MSE: %f\n\n", log[k], m[k]);
            }*/
            
            TFT.locate(165,270);
            printf("Return");
            TFT.rect(150,265,220,285,Green);
            while(1)
            {   ps = ain3.read();
                if (ps==1)  {   wait(0.3);  TFT.cls();  stage=0;   break; }
            }
        }
        
        if (stage==4)                                       //recording... for comparison
        {   TFT.set_font((unsigned char*) Arial24x23);
            TFT.foreground(White);
            TFT.locate(40, 240);
            printf(" recording\n  comparison...");
            TFT.set_font((unsigned char*) Arial12x12);
            //DFSDM CORE
                pc.printf("\r\n\r\nEntering AudioRecord_demo()...\r\n");
                RECORD();   // RECORD CONTROL 0
                uint32_t n;
                for(n=0;n<1024;n++)
                {CONTROLPWR[n]=POWER[n];}
                for(n=0;n<1024;n++)
                {CONTROLPHS[n]=PHS[n];}
                RECORD(); //RECORD CONTROL 1
                MSE(); //MSE BETWEEN CONTROLS
                CONTROLPWRMSE=PWRMSE;
                CONTROLPHSMSE=PHSMSE;
            //
            TFT.cls();
            comp=1;
            menu=0;
            config=2;
            stage=1;
        }
        
        if (stage==5)                                       //recording...  with interval
        {   int t = 4*(h*60+m);
            int t1, abc;
            float32_t sum, sum_mse, sum_st;
            TFT.set_font((unsigned char*) Arial24x23);
            TFT.locate(20,60);
            TFT.foreground(DarkGrey);
            printf("Configuration");
            TFT.locate(50,110);
            TFT.printf("Waveform");
            TFT.locate(95,160);
            TFT.printf("Log");
            TFT.set_font((unsigned char*) Arial12x12);
            TFT.foreground(White);
            TFT.locate(30, 240);
            printf("recording, are you sure?");
            TFT.set_font((unsigned char*) Arial24x23);
            TFT.locate(35,260);
            printf("   STOP   ");
            TFT.rect(13,255,225,285,Green);
 
            while (stage==5)
            {   sum=0;      sum_mse=0;      sum_st=0;       t1=0;

                RECORD();
                MSE();
                COMPARE();

                for(abc=0; abc<samplenum; abc++)
                {   a1 = a[abc];    b1 = b[abc];    sum = sum+a[abc];
                    arm_sub_f32(&a1, &stmean, &SubOutST, 1);
                    arm_mult_f32(&SubOutST, &SubOutST, &SquareOutST, 1);
                    sum_st = sum_st+SquareOutST;
                    arm_sub_f32(&a1, &b1, &SubOutMSE, 1);
                    arm_mult_f32(&SubOutMSE, &SubOutMSE, &SquareOutMSE, 1);
                    sum_mse = sum_mse+SquareOutMSE;
                }
                stmean = sum/samplenum;
                stst = sqrt(sum_st/samplenum);
                stmse = sum_mse/samplenum;          
                
//                if (stmse>0)                    //  if error, send to user, and store MSE to log
//                {   if (mselog[0]==NULL)
//                    {   time_t seconds = time(NULL);
//                        strftime(log[0], 32, "%b %d %Y  %I:%M %p\n", localtime(&seconds));
//                        mselog[0] = stmse;
//                    }
//                }               
        
                while(t1<t)
                {   ps = ain3.read();
                    if (ps==0)    {   t1++;   wait(0.2);    }
                    else if (ps==1)  {   wait(0.3);  TFT.cls();  stage=0;   break; }
                } 
            }        
        }  
    }
}

