
#include "main.h"
#include "stm32l476g_discovery_audio.h"
//
#include "SPI_TFT_ILI9341.h"
#include <math.h>
#include "stdio.h"
#include "mbed.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "arm_math.h" 
#include "SDFileSystem.h"
//
//GLOBAL VARIABLES 
float32_t POWER[1024];
float32_t PHS[1024];
float32_t PWRMSE;
float32_t PHSMSE;
uint32_t n;  //Generic variable for "for" loops
float32_t CONTROLPWR[1024]; //CONTROL 0 PWR
float32_t CONTROLPHS[1024]; //CTONROL 0 PHS
float32_t CONTROLPWRMSE;//CONTROL PWR MSE
float32_t CONTROLPHSMSE;//CONTROL PHS MSE
extern SPI_TFT_ILI9341 TFT;

                                                        
void RECORD(void)
{
    int row =0;
    uint32_t counter=0;
    int EXIT=0; //WHILE LOOP EXIT FLAG
//    uint16_t PDMBUFF[1536];
    uint16_t RECORDBUFF[2048];
    float32_t FLOATBUFF[4096];
    const arm_cfft_instance_f32 *S=&arm_cfft_sR_f32_len2048;
    
    /* Initialize audio input */  
    pc.printf("\r\n");
    pc.printf("Initializing Audio...\r\n");                          
    if(Audio_Init()!= AUDIO_OK)
        {
        TFT.locate(10,row); TFT.printf("FAILED to initialize audio...\r\n"); row+=20; 
        //pc.printf("FAILED to initialize audio...\r\n");
        }
    //pc.printf("Initialization completed successfully.\r\n");
    else 
    {TFT.locate(10,row); TFT.printf("Initialization completed successfully.\r\n"); row+=20;}
  /* Start the audio record */

        if (Audio_Record(RECORDBUFF) != AUDIO_OK)
            {
                TFT.locate(10,row); TFT.printf("FAILED to begin recording...\r\n"); row+=20;
//                pc.printf("FAILED to begin recording...\r\n");
            } 
            
//    pc.printf("DMA\tSPI\tRXNE\tBSY\tCRCERR\tOVR\r\n");
  
  /* PCM samples recording loop */
//  RecordBufferOffset = BUFFER_OFFSET_NONE;
//  while (RecordBufferOffset != BUFFER_OFFSET_FULL);
  
//  while (EXIT != SET)
//  {
//        if (!(counter%1000000)) pc.printf("%d\t%d\t%d\t%d\t%d\t%d\r\n", getDMAState(), getSPIState(), getSPIFlagStatus(SPI_SR_RXNE), getSPIFlagStatus(SPI_SR_BSY), getSPIFlagStatus(SPI_SR_CRCERR), getSPIFlagStatus(SPI_SR_OVR));
//        if (counter==10000000) //Approximately 3 seconds of record time
//        {
//            EXIT=1;
//        }
//        else
//        {
//            counter=counter++;
//        }
//  }
  /* Stop audio input */
    Audio_Stop();
    TFT.locate(10,row); TFT.printf("Audio recording processed successfully!\r\n"); row+=20;
//    pc.printf("Audio recording processed successfully!\r\n");
    //myled = 0;
    WriteData(RECORDBUFF);
        
    for(n=0;n<2048;n++)
    {
        FLOATBUFF[n*2] = (float)RECORDBUFF[n];
        FLOATBUFF[(n*2)+1] = 0.0;
     }
     arm_cfft_f32(S, FLOATBUFF, 0,0); //Output of FFT is half the record buffer size

            for(n=0;n<1024;n++)
                {PHS[n]=atan2(FLOATBUFF[(n*2)+1],FLOATBUFF[n*2]);}//Calculates control phase
            for(n=0;n<1024;n++)
                {
                    POWER[n]=sqrt((FLOATBUFF[(n*2)+1]*FLOATBUFF[(n*2)+1])+(FLOATBUFF[n*2]*FLOATBUFF[n*2]));
                    } //calculates control power
}

void MSE(void)
{
    float32_t compare[1024]; //BUFFER VARIABLE FOR MSE FUNCTIONS
    //MEAN SQUARED ERROR FOR SAMPLE MAGNITUDES
    PWRMSE=0;
    for(n=0;n<1024;n++)
        {compare[n]=(CONTROLPWR[n]-POWER[n])*(CONTROLPWR[n]-POWER[n]);} //Error between FFT magnitudes, stored in compare
    for(n=0;n<1024;n++)
        {PWRMSE=PWRMSE+compare[n];} //Takes the mean of the error, stores MSE in CONTROLMSE
    PWRMSE=PWRMSE/1024.0f;
    //MEAN SQUARED ERROR FOR SAMPLE PHASE
    PHSMSE=0;
    for(n=0;n<1024;n++)
        {compare[n]=(CONTROLPHS[n]-PHS[n])*(CONTROLPHS[n]-PHS[n]);} //Error between FFT magnitudes, stored in compare
    for(n=0;n<1024;n++)
        {PHSMSE=PHSMSE+compare[n];} //Takes the mean of the error, stores MSE in CONTROLMSE
    PHSMSE=PHSMSE/1024.0f;
}

void COMPARE(void)
{
    float32_t TEST[4];
            TEST[0]=001; //LOW END OF ACCEPTED TOLERANCE RANGE
            TEST[1]=20;  //HIGH END OF ACCEPTED TOLERANCE RANGE
            TEST[2]=(PWRMSE/CONTROLPWRMSE); //The ratio of sample MSE and control MSE
            TEST[3]=(PHSMSE/CONTROLPHSMSE);
                        
                //COMPARISON
                    //if(SAMPLEPHASEMSE>(10*PHSCONTROLMSE))
                        //{
                            //SEND ERROR MESSAGE
                            //CREATE EVENT
                        //}
                    if(TEST[2]>TEST[0])//MODEM FUNCTIONS
                        {
                            //SEND ERROR MESSAGE
                            //CREATE EVENT
                        }
                    if(TEST[2] < TEST[1])
                        {   
                            //SEND ERROR MESSAGE
                            //CREATE EVENT
                        }
}