//#include "oslmic.h"
#include "lmic.h"
#include "debug.h"
#include "mbed.h"

Serial pc(USBTX, USBRX);

static DigitalOut red_led(PB_1);
#define LED_ON  0
#define LED_OFF 1

void debug_init()
{
    pc.baud(115200);

    // print banner
    debug_str("\r\n============== DEBUG STARTED ==============\r\n");

    red_led = LED_OFF;
}

void debug_str (const char* str)
{
    debug("%s", str);
}

void debug_event (int ev)
{
    static const char* evnames[16] = {
        "???",
        "SCAN_TIMEOUT",
        "BEACON_FOUND",
        "BEACON_MISSED",
        "BEACON_TRACKED",
        "JOINING",
        "JOINED",
        "RFU1",
        "JOIN_FAILED",
        "REJOIN_FAILED",
        "TXCOMPLETE",
        "LOST_TSYNC",
        "RESET",
        "RXCOMPLETE",
        "LINK_DEAD",
        "LINK_ALIVE"
    };

    debug("%s\r\n", evnames[ev]);
}

void debug_val (const char* label, u4_t val)
{
    debug("%s%d\r\n", label, val);
}

void debug_buf(const u1_t* buf, u2_t len)
{
    while (len--) {
        debug("%02x ", *buf++);
    }
    debug("\r\n");
}

void debug_led(unsigned char on)
{
    if (on)
        red_led = LED_ON;
    else
        red_led = LED_OFF;
}

void debug_done()
{
    /* block until last bit sent out debug UART */
    while (!(USART2->SR & UART_FLAG_TC))
        __NOP();
}
