/***
 *       _____                         _   
#if defined MTDOT_UDK
 *      / ____|                       | |  
 *     | (___     ___   _ __     ___  | |_ 
 *      \___ \   / _ \ | '_ \   / _ \ | __|
 *      ____) | |  __/ | | | | |  __/ | |_ 
 *     |_____/   \___| |_| |_|  \___|  \__|
 *         (C) 2016 Senet, Inc                                
 *                                         
 */
#if defined MTDOT_UDK

#include "board_udk.h"
#include "x_nucleo_iks01a1.h"

extern void mDotInit();

Serial debugUART(USBTX, USBRX);
DigitalOut      led1(PA_0);
static X_NUCLEO_IKS01A1 *mems_shield;


CBoardUDK::CBoardUDK()
{
	boardPtr = this;
}

EBoardStatus CBoardUDK::init()
{
	CBoard::init();
	mems_shield = X_NUCLEO_IKS01A1::Instance(NULL, NC);

	return Board_Ok;
}

EBoardStatus CBoardUDK::readSensors ( BoardSensorData &data )
{
    uint32_t ret = 0;
    int32_t  accel_data[3];

   // Temperature
   ret |= (!CALL_METH(mems_shield->pt_sensor, GetTemperature, &data.temperature, 0.0f) ? 0x0 : 0x1);

   // Pressure
   ret |= (!CALL_METH(mems_shield->pt_sensor, GetPressure, &data.pressure, 0.0f) ? 0x0 : 0x1);

   // Accelerometer
   MotionSensor *motionSensor = mems_shield->GetAccelerometer();
   if( motionSensor != NULL)
   {
       motionSensor->Get_X_Axes(accel_data);

       data.accel_x = accel_data[0];
       data.accel_y = accel_data[1];
       data.accel_z = accel_data[2];
       /*  z-axis : > 0 = rightside up, < 0 upside down
        *  x-axis: com LED to the left x < 0, x > 0 on the right
        *  y-axis: y > 0 COM LED down, y < 0  COM LED up
        */
       data.orientation.init();

       // rightside up
       if(data.accel_z >= 750)
       {
           // data.orientation.horizontal = true;
       }
       // upside down
       else if(data.accel_z <= -750)
       {
           data.orientation.down  = true;
           // position_value = (2 << 12) | (1 << 8);
       }
       // vertical down
       else if(data.accel_y >= 900 )
       {
           data.orientation.vertical = true;
           data.orientation.down     = true;
       }
       // vertical up
       else if(data.accel_y <= -900 )
       {
           data.orientation.vertical = true;
           data.orientation.up       = true;
       }
       // side right
       else if(data.accel_x > 900)
       {
           data.orientation.right = true;
       }
       // side left
       else
       {
           data.orientation.left = true;
       }
   }

   return Board_Ok;
}

EBoardStatus CBoardUDK::setLED(uint8_t ledNum, bool on)
{
	if(ledNum == 1)
	{
		led1 = on ? 0 : 1;
		return Board_Ok;
	}
	return Board_Invalid;
}

EBoardStatus CBoardUDK::toggleLED(uint8_t ledNum)
{
	if(ledNum == 1)
	{
		led1 = !led1;
		return Board_Ok;
	}
	return Board_Invalid;
}

#endif
