/***
 *       _____                         _   
 *      / ____|                       | |  
 *     | (___     ___   _ __     ___  | |_ 
 *      \___ \   / _ \ | '_ \   / _ \ | __|
 *      ____) | |  __/ | | | | |  __/ | |_ 
 *     |_____/   \___| |_| |_|  \___|  \__|
 *         (C) Senet, Inc                                
 *                                         
 */
#ifndef BOARD_BOARD_H_
#define BOARD_BOARD_H_

#include "mbed.h"
#include "mDot.h"

extern Serial     debugUART;
extern mDot       *mDotPtr;

enum EBoardState
{
	Board_init,
	Board_start,
	Board_stop,
};

struct BoardOrientation
{
	bool vertical;
	bool up;
	bool down;
	bool right;
	bool left;

	void init()
	{
		vertical = false;
		up       = false;
		down     = false;
		right    = false;
		left     = false;
	}

	BoardOrientation() { init(); }
};

/*
 * Board sensor data
 */
struct BoardSensorData
{
    float temperature;
    float pressure;
    int32_t accel_x;
    int32_t accel_y;
    int32_t accel_z;
    BoardOrientation orientation;

    inline void init()
    {
        temperature= 0;
        pressure = 0;
        accel_x = 0;
        accel_y = 0;
        accel_z = 0;
        orientation.init();
    }

    BoardSensorData() { init(); }
};

enum EBoardStatus
{
	Board_Ok,
	Board_Fail,
	Board_Invalid
};

typedef void (*PB_FUNC)(uint8_t button);

EBoardStatus BoardInit();

class CBoard
{
	public:

		static EBoardStatus ReadSensors(BoardSensorData  &data ) { return (  ( boardPtr != 0 ) ? boardPtr->readSensors( data ) : Board_Fail ); }
		static EBoardStatus Init()                               { return (  ( boardPtr != 0 ) ? boardPtr->init( )  : Board_Fail ); }
		static EBoardStatus Start()                              { return (  ( boardPtr != 0 ) ? boardPtr->start( ) : Board_Fail ); }
		static EBoardStatus SetLED(uint8_t ledNum, bool on)      { return (  ( boardPtr != 0 ) ? boardPtr->setLED(ledNum, on ) : Board_Fail ); }
		static EBoardStatus ToggleLED(uint8_t ledNum)            { return (  ( boardPtr != 0 ) ? boardPtr->toggleLED(ledNum) : Board_Fail ); }
		static void         SetButtonCallback(PB_FUNC func)      { buttonCallback =  func; }

	protected:

		virtual EBoardStatus init();
		virtual EBoardStatus readSensors ( BoardSensorData &data ) { return Board_Fail; }
		virtual EBoardStatus start()                               { return Board_Ok;   }
		virtual EBoardStatus setLED(uint8_t ledNum, bool on)       { return Board_Fail; }
		virtual EBoardStatus toggleLED(uint8_t ledNum)             { return Board_Fail; }

		static PB_FUNC  buttonCallback;
		static CBoard  *boardPtr;

		friend EBoardStatus BoardInit();

};

#endif /* BOARD_BOARD_H_ */
